package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import java.io.IOException;
import java.util.List;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Interface to retrieve the Id's of mandatory aspects.
 * All Retrieve implementation must implement this interface
 * if should be used as retriever.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public interface OwCMISALAspectRetriever
{
    /**optional configuration node for specific retriever class in network configuration*/
    public static final String RETRIEVER_CLASS = "AspectRetrieverClass";
    /**optional configuration for the URL to be used for mandatory aspect retrieving*/
    public static final String RETRIEVER_URL = "AspectRetrieveUrl";

    /**CMIS id prefix used to represent Aspects*/
    public static final String PREFIX_ASPECT = "P:";

    /**
     * Will return a list of Id's which must not conform with the Alfresco CMIS Id representation. 
     * The requester/caller must handle/check the id regarding it's needs.
     * @param network OwCMISNetwork to get configuration
     * @param clazz OwCMISObjectClass for which the list of mandatory aspect Id's should be retrieved. 
     * @return List of Strings representing the Id's
     * @throws IOException If could not communicate with server (could not create connection)
     * @throws OwException if could not retrieve configuration from network instance
     */
    List<String> retrieveAspectIds(OwCMISNetwork network, OwCMISObjectClass clazz) throws IOException, OwException;

}
