package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import java.util.HashMap;
import java.util.Map;

import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISExtensionLibrary;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISNetworkExtension;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectExtension;

/**
 *<p>
 * Alfresco 3.4 and higher extension library. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwCMISALExtensionLibrary implements OwCMISExtensionLibrary
{

    private Map<String, Map<Class<?>, Object>> configuredExtensions;

    public OwCMISALExtensionLibrary()
    {
        this.configuredExtensions = new HashMap<String, Map<Class<?>, Object>>();
        OwCMISALObjectExtension objectExtension = new OwCMISALObjectExtension();
        addExtension(OwCMISObjectBase.CUSTOMIZE_CLASS_EP, OwCMISObjectExtension.class, objectExtension);
        addExtension(OwCMISObjectBase.PROCESS_NATIVE_PROPERITIES_EP, OwCMISObjectExtension.class, objectExtension);
        addExtension(OwCMISObjectBase.REQUEST_CACHED_PROPERITIES_EP, OwCMISObjectExtension.class, objectExtension);
        addExtension(OwCMISObjectBase.FILTER_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, objectExtension);
        addExtension(OwCMISObjectBase.ADD_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, objectExtension);

        OwCMISALNetworkExtension networkExtension = new OwCMISALNetworkExtension();
        addExtension(OwCMISNetworkExtension.TWEAK_OBJECT_EP, OwCMISNetworkExtension.class, networkExtension);
        addExtension(OwCMISNetworkExtension.PREPARE_OBJECT_CLASS_EP, OwCMISNetworkExtension.class, networkExtension);
        addExtension(OwCMISNetworkExtension.PREPARE_FOR_CREATION_EP, OwCMISNetworkExtension.class, networkExtension);
    }

    protected synchronized <E> void addExtension(String extensionnId_p, Class<E> extensionClass_p, E extension_p)
    {
        Map<Class<?>, Object> idMap = this.configuredExtensions.get(extensionnId_p);
        if (idMap == null)
        {
            idMap = new HashMap<Class<?>, Object>();
            this.configuredExtensions.put(extensionnId_p, idMap);
        }
        idMap.put(extensionClass_p, extension_p);
    }

    @SuppressWarnings("unchecked")
    public synchronized <E> E getExtension(String extensionId_p, Class<E> extensionClass_p)
    {
        Map<Class<?>, Object> idMap = this.configuredExtensions.get(extensionId_p);
        E extension = null;
        if (idMap != null)
        {
            Object extensionObject = idMap.get(extensionClass_p);
            if (extensionObject != null)
            {
                if (extensionClass_p.isAssignableFrom(extensionObject.getClass()))
                {
                    extension = (E) extensionObject;
                }
            }
        }

        return extension;
    }

}
