package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.alfresco.Aspects;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISNetworkExtension;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Alfresco network extension. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwCMISALNetworkExtension implements OwCMISNetworkExtension
{
    private static final Logger LOG = OwLog.getLogger(OwCMISALNetworkExtension.class);

    public CmisObjectType tweakSearchResult(CmisObjectType object_p, OwQueryStatement statement_p, OwCMISNetwork network_p) throws OwException
    {
        Map<String, OwColumnQualifier> nQualifiers = statement_p.getNormalizedQualifiers();

        if (nQualifiers.size() > 1)
        {
            OwColumnQualifier mainTable = statement_p.getMainTableQualifier();
            String resourceID = statement_p.getTargetRepositoryID();
            OwCMISResource resource = network_p.getResource(resourceID);
            OwCMISObjectClass policyClass = network_p.getObjectClass("cmis:policy", resource);
            String mainType = mainTable.getTargetObjectType();
            OwCMISObjectClass mainClass = network_p.getObjectClass(mainType, resource);
            if (policyClass.isAssignableFrom(mainClass))
            {
                return object_p;
            }
            else
            {
                CmisPropertiesType properties = object_p.getProperties();
                List<CmisProperty> propertyList = properties.getProperty();
                List<CmisProperty> aspectProperties = new LinkedList<CmisProperty>();
                Set<String> queriedAspects = new HashSet<String>();
                for (CmisProperty property : propertyList)
                {
                    String id = property.getPropertyDefinitionId();
                    int dotIndex = id.indexOf('.');
                    if (dotIndex > -1 && dotIndex + 1 < id.length())
                    {
                        String qString = id.substring(0, dotIndex);
                        String realPropertyId = id.substring(dotIndex + 1, id.length());
                        property.setPropertyDefinitionId(realPropertyId);
                        OwColumnQualifier qualifiers = nQualifiers.get(qString);
                        String qTypeString = qualifiers.getTargetObjectType();
                        OwCMISObjectClass qType = network_p.getObjectClass(qTypeString, resource);
                        if (policyClass.isAssignableFrom(qType))
                        {
                            aspectProperties.add(property);
                            queriedAspects.add(qTypeString);
                        }
                    }
                }

                Aspects aspects = new Aspects();
                CmisPropertiesType aspectPropertiesType = new CmisPropertiesType();
                aspects.setProperties(aspectPropertiesType);
                aspectPropertiesType.getProperty().addAll(aspectProperties);
                aspects.getAppliedAspects().addAll(queriedAspects);
                List<Object> any = properties.getAny();
                any.add(aspects);
                any.add(new OwCMISALCacheInfo(false));
            }
        }

        return object_p;
    }

    public OwCMISObjectClass prepareObjectClass(OwCMISObjectClass class_p, OwCMISNetwork network_p) throws OwException
    {
        return prepareForCreation(new OwCMISALObjectClass(class_p, network_p), network_p);
    }

    public OwCMISObjectClass prepareForCreation(OwCMISObjectClass objectClass_p, OwCMISNetwork network_p) throws OwException
    {
        if (!OwCMISALAspectsService.isCacheInitialised(objectClass_p))
        {
            OwCMISALAspectsService service = new OwCMISALAspectsService();
            try
            {
                service.ensureMandatroyAspects(network_p, objectClass_p);
            }
            catch (IOException e)
            {
                if (LOG.isDebugEnabled())
                {
                    LOG.debug("Problem requesting Aspect definitions (OwCMISALNetworkExtension)", e);
                }
                else
                {
                    LOG.warn("Problem requesting Aspect definitions (OwCMISALNetworkExtension), exception message = " + e.getMessage());
                }
            }
        }

        return objectClass_p;
    }
}
