package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import java.util.List;
import java.util.Map.Entry;
import java.util.Set;

import org.alfresco.Aspects;
import org.alfresco.SetAspects;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;

import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectExtension;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Alfresco object extension. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwCMISALObjectExtension implements OwCMISObjectExtension
{
    public OwCMISObjectClass customizeClass(CmisObjectType object_p, OwCMISObjectClass defaultObjectClass_p, OwCMISNetwork network_p) throws OwException
    {
        return new OwCMISAlfrescoObjectClass(defaultObjectClass_p, object_p, network_p);
    }

    public OwPropertyCollection processNativeProperties(OwCMISObject object_p, OwPropertyCollection processedProperties_p, CmisPropertiesType nativeProperties_p, OwCMISNetwork network_p) throws OwException
    {
        List<Object> any = nativeProperties_p.getAny();
        Aspects aspects = OwCMISALUtil.findFirst(any, Aspects.class);
        if (aspects != null)
        {
            CmisPropertiesType properties = aspects.getProperties();
            List<CmisProperty> propertyList = properties.getProperty();
            OwCMISObjectClass oClass = object_p.getObjectClass();
            for (CmisProperty cmisProperty : propertyList)
            {
                String id = cmisProperty.getPropertyDefinitionId();
                OwCMISNativePropertyClass propertyClass = (OwCMISNativePropertyClass) oClass.getPropertyClass(id);
                String propertyId = null;
                if (processedProperties_p.containsKey(id))
                {
                    propertyId = id;
                }
                if (processedProperties_p.containsKey(propertyClass.getFullQualifiedName()))
                {
                    propertyId = propertyClass.getFullQualifiedName();
                }
                if (propertyId != null)
                {
                    OwCMISNativeProperty property = propertyClass.createProperty(cmisProperty, network_p);
                    processedProperties_p.put(propertyId, property);
                }
            }
        }
        return processedProperties_p;
    }

    public OwCMISNativeProperty requestCachedProperty(OwCMISObjectBase object_p, OwCMISNativePropertyClass propertyClass_p, OwCMISNetwork network_p) throws OwException
    {
        CmisObjectType cmisObject = object_p.getNativeObject();
        CmisPropertiesType properties = cmisObject.getProperties();
        List<Object> inOutAny = properties.getAny();
        if (inOutAny != null)
        {
            String nqName = propertyClass_p.getNonQualifiedName();

            Aspects aspects = OwCMISALUtil.findFirst(inOutAny, Aspects.class);
            if (aspects != null)
            {
                CmisPropertiesType aspectProperties = aspects.getProperties();
                if (aspectProperties != null)
                {
                    List<CmisProperty> aspectPropertiesList = aspectProperties.getProperty();
                    for (CmisProperty cmisProperty : aspectPropertiesList)
                    {
                        if (nqName.equals(cmisProperty.getPropertyDefinitionId()))
                        {
                            return propertyClass_p.createProperty(cmisProperty, network_p);
                        }
                    }
                }
            }
        }
        return null;
    }

    public OwPropertyCollection filterPropertyExtensions(OwCMISResource resource_p, String objectClass_p, OwPropertyCollection properties_p) throws OwException
    {
        OwStandardPropertyCollection filter = new OwStandardPropertyCollection();
        OwCMISObjectModel om = resource_p.getObjectModel();
        OwCMISObjectClass mainClass = om.getObjectClass(objectClass_p);
        Set propertyEntries = properties_p.entrySet();
        for (Object object : propertyEntries)
        {
            Entry entry = (Entry) object;
            String propertyId = (String) entry.getKey();
            try
            {
                mainClass.getPropertyClass(propertyId);
            }
            catch (OwException e)
            {
                filter.put(propertyId, entry.getValue());
            }
        }

        return filter;
    }

    public CmisPropertiesType addPropertyExtensions(CmisPropertiesType nativeProperties_p, OwPropertyCollection propertyExtensions_p, OwCMISObject object_p, String resourceID_p, OwCMISNetwork network_p) throws OwException
    {
        if (propertyExtensions_p != null)
        {

            OwCMISPropertyCollectionConverter converter = new OwCMISStandardPropertyCollectionConverter();

            CmisPropertiesType extensionProperties = converter.createCmisProperties(propertyExtensions_p, object_p, resourceID_p, network_p);
            SetAspects aspects = new SetAspects();
            aspects.setProperties(extensionProperties);

            nativeProperties_p.getAny().add(aspects);
        }
        return nativeProperties_p;
    }
}
