package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import java.util.LinkedList;
import java.util.List;

import org.alfresco.Aspects;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Object-class used with Alfresco extensions.<br/>
 * A new instance of this object-class is created for each alfresco based CMIS {@link OwObject} 
 * to provide Alfresco-aspect object information (applied aspects and corresponding properties and property values).
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 *@see OwCMISALExtensionLibrary 
 */
public class OwCMISAlfrescoObjectClass extends OwCMISALObjectClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISAlfrescoObjectClass.class);

    private CmisObjectType object;

    public OwCMISAlfrescoObjectClass(OwCMISObjectClass primaryClass_p, CmisObjectType object_p, OwCMISNetwork network_p) throws OwException
    {
        super(primaryClass_p, network_p);
        this.object = object_p;
    }

    public List<String> getAppliedAspectTypes() throws OwException
    {
        OwCMISResource resource = getResource();
        Aspects aspects = OwCMISALUtil.resolveAspects(this.object, getNetwork(), resource.getID());
        List<String> ret = new LinkedList<String>();
        if (aspects != null)
        {
            for (String asp : aspects.getAppliedAspects())
            {
                if (!(asp.startsWith("P:sys") || asp.startsWith("P:cm")))
                {
                    ret.add(asp);
                }
                else
                {
                    LOG.debug("OwCMISAlfrescoObjectClass.getAppliedAspectTypes : Aspect " + asp + " filtered out.");
                }
            }
        }
        return ret;
    }

    public boolean isAssignableFrom(OwCMISObjectClass class_p) throws OwException
    {
        /* This will return by default false, the identification if two classes are 
         * from the same type would be very complex. An instance class will be 
         * "assignable" if the provided class would represent similar dependencies  
         * to other "Aspect" classes: 
         * if (cmisClass.isAssignableFrom(cmisClass_p)
         * {
         *  foreach(Aspect aspectClass : cmisClass)
         *  {
         *   foreach(Aspect compareAspect : cmisClass_p)
         *   {
         *     aspectClass.isAssignableFrom(compareAspect);
         *   }
         *  }
         * } 
         */
        return false;
    }

}