package com.wewebu.ow.server.ecmimpl.cmis.broker;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISListBroker.
 * Helper class for the broker map, containing the list of listeners
 * which will be notified on for registered events.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISListBroker<L>
{
    private static final Logger LOG = OwLog.getLogger(OwCMISListBroker.class);

    private List<SoftReference<OwCMISListenerHandler<L>>> listeners = new LinkedList<SoftReference<OwCMISListenerHandler<L>>>();

    public void register(OwCMISListenerHandler<L> listenerHandler_p)
    {
        listeners.add(new SoftReference<OwCMISListenerHandler<L>>(listenerHandler_p));
        listenerHandler_p.createBrokerPhantom(this);
    }

    @SuppressWarnings("unchecked")
    public synchronized void fire(OwCMISEventDispatch<L> handler_p) throws OwException
    {
        for (Iterator i = this.listeners.iterator(); i.hasNext();)
        {
            SoftReference<OwCMISListenerHandler<L>> listenerReference = (SoftReference<OwCMISListenerHandler<L>>) i.next();
            OwCMISListenerHandler<L> listener = listenerReference.get();
            if (listener != null)
            {
                listener.fire(handler_p);
            }
            else
            {
                i.remove();
            }
        }
    }

    public void logLoad()
    {
        if (LOG.isDebugEnabled())
        {
            int refereceCount = this.listeners.size();
            int disposableReferenceCount = 0;
            for (SoftReference<OwCMISListenerHandler<L>> reference : this.listeners)
            {
                if (reference.get() == null)
                {
                    disposableReferenceCount++;
                }
            }
            LOG.debug("OwCMISListBroker.logLoad : references=" + refereceCount + " disposable=" + disposableReferenceCount);
        }
        else
        {
            LOG.warn("OwCMISListBroker.logLoad : load logging is obly enabled in debug mode!");
        }
    }
}
