package com.wewebu.ow.server.ecmimpl.cmis.broker;

import java.util.LinkedList;
import java.util.List;

import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISListenerHandler.
 * Helper class to delegate the listener to the specific handler, based on 
 * the visitor pattern.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISListenerHandler<L>
{
    private L listener;
    private List<Object> brokerPhantoms = new LinkedList<Object>();

    public OwCMISListenerHandler(L listener_p)
    {
        this.listener = listener_p;
    }

    synchronized void createBrokerPhantom(Object broker_p)
    {
        this.brokerPhantoms.add(broker_p);
    }

    /**
     * Visitor pattern delegation method, depending on the given
     * handler the listener will be called with specialized
     * handler implementation.
     * @param handler_p OwCMISDispatch
     * @throws OwException
     */
    synchronized void fire(OwCMISEventDispatch<L> handler_p) throws OwException
    {
        handler_p.fire(listener);
    }
}
