package com.wewebu.ow.server.ecmimpl.cmis.broker;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISMapBroker.
 * Broker map of resources id to the depending broker list of handlers.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@see OwCMISListBroker
 */
public class OwCMISMapBroker<L>
{
    private static final Logger LOG = OwLog.getLogger(OwCMISMapBroker.class);

    private Map<String, SoftReference<OwCMISListBroker<L>>> brokersMap = new HashMap<String, SoftReference<OwCMISListBroker<L>>>();
    private List<String> idsQueue = new ArrayList<String>();

    private int overloadThreshold = 1000;
    private int candidateFactor = 30;

    public synchronized void register(String listId_p, OwCMISListenerHandler<L> listenerHandler_p)
    {
        SoftReference<OwCMISListBroker<L>> brokerReference = this.brokersMap.get(listId_p);
        OwCMISListBroker<L> broker = null;

        if (brokerReference != null)
        {
            broker = brokerReference.get();
        }
        else
        {
            this.idsQueue.add(listId_p);
        }

        if (broker == null)
        {
            broker = new OwCMISListBroker<L>();
            this.brokersMap.put(listId_p, new SoftReference<OwCMISListBroker<L>>(broker));
        }

        broker.register(listenerHandler_p);
        collect();
    }

    private synchronized void collect()
    {
        if (this.brokersMap.size() > overloadThreshold)
        {
            int listsCount = this.brokersMap.size();
            int overload = listsCount - overloadThreshold;
            int candidateCount = Math.min(listsCount, overload * candidateFactor);
            //            int collectCount = candidateCount;
            for (int i = 0; i < candidateCount; i++)
            {
                String listId = this.idsQueue.get(i);
                SoftReference<OwCMISListBroker<L>> brokerReference = this.brokersMap.get(listId);
                if (brokerReference.get() == null)
                {
                    this.brokersMap.remove(listId);
                    this.idsQueue.remove(i);
                    candidateCount--;
                    i--;
                }
            }

            //            collectCount = collectCount - candidateCount;
        }
    }

    synchronized void fire(String listId_p, OwCMISEventDispatch<L> eventHandler_p) throws OwException
    {
        SoftReference<OwCMISListBroker<L>> brokerReference = this.brokersMap.get(listId_p);
        OwCMISListBroker<L> broker = null;

        if (brokerReference != null)
        {
            broker = brokerReference.get();
        }

        if (broker != null)
        {
            broker.fire(eventHandler_p);
        }
        else
        {
            if (brokerReference != null)
            {
                this.brokersMap.remove(listId_p);
                this.idsQueue.remove(listId_p);
            }
        }
    }

    public synchronized void logLoad()
    {
        if (LOG.isDebugEnabled())
        {
            Set<Entry<String, SoftReference<OwCMISListBroker<L>>>> entries = this.brokersMap.entrySet();
            int entriesCount = entries.size();
            int disposableEntriesCount = 0;
            for (Entry<String, SoftReference<OwCMISListBroker<L>>> entry : entries)
            {
                SoftReference<OwCMISListBroker<L>> listReference = entry.getValue();
                if (listReference.get() == null)
                {
                    disposableEntriesCount++;
                }
            }
            LOG.debug("OwCMISMapBroker.logLoad : entries=" + entriesCount + " disposable=" + disposableEntriesCount);
        }
        else
        {
            LOG.warn("OwCMISMapBroker.logLoad : load logging is obly enabled in debug mode!");
        }
    }

}
