package com.wewebu.ow.server.ecmimpl.cmis.broker;

import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISObjectBroker.
 * Object Broker which instantiates and register the different handler, depending on the 
 * given resource and version series ID.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISObjectBroker implements OwCMISVersionEventListener
{
    private OwCMISResourceBroker<OwCMISVersionEventListener> versionEventBroker = new OwCMISResourceBroker<OwCMISVersionEventListener>();

    public void register(String resourceId_p, String versioSeriesId_p, OwCMISListenerHandler<OwCMISVersionEventListener> handler_p)
    {
        this.versionEventBroker.register(resourceId_p, versioSeriesId_p, handler_p);
    }

    public void versionCheckedOut(final String resourceId_p, final String versionSeriesId_p, final CmisObjectType pwcObject_p, final String oldVersionId_p) throws OwException
    {
        OwCMISEventDispatch<OwCMISVersionEventListener> eventHandler = new OwCMISEventDispatch<OwCMISVersionEventListener>() {

            public void fire(OwCMISVersionEventListener listener_p) throws OwException
            {
                listener_p.versionCheckedOut(resourceId_p, versionSeriesId_p, pwcObject_p, oldVersionId_p);
            }

        };
        versionEventBroker.fire(resourceId_p, versionSeriesId_p, eventHandler);
    }

    public void versionCanceledChenckedOut(final String resourceId_p, final String versionSeriesId_p, final CmisObjectType currentObject_p, final String pwcVersionId_p) throws OwException
    {
        OwCMISEventDispatch<OwCMISVersionEventListener> eventHandler = new OwCMISEventDispatch<OwCMISVersionEventListener>() {

            public void fire(OwCMISVersionEventListener listener_p) throws OwException
            {
                listener_p.versionCanceledChenckedOut(resourceId_p, versionSeriesId_p, currentObject_p, pwcVersionId_p);
            }

        };
        versionEventBroker.fire(resourceId_p, versionSeriesId_p, eventHandler);
    }

    public void versionCheckedIn(final String resourceId_p, final String versionSeriesId_p, final CmisObjectType currentObject_p, final String pwcVersionId_p) throws OwException
    {
        OwCMISEventDispatch<OwCMISVersionEventListener> eventHandler = new OwCMISEventDispatch<OwCMISVersionEventListener>() {

            public void fire(OwCMISVersionEventListener listener_p) throws OwException
            {
                listener_p.versionCheckedIn(resourceId_p, versionSeriesId_p, currentObject_p, pwcVersionId_p);
            }

        };
        versionEventBroker.fire(resourceId_p, versionSeriesId_p, eventHandler);
    }

    public void versionSaved(final String resourceId_p, final String versionSeriesId_p, final CmisObjectType currentObject_p, final String oldVersionId_p) throws OwException
    {
        OwCMISEventDispatch<OwCMISVersionEventListener> eventHandler = new OwCMISEventDispatch<OwCMISVersionEventListener>() {

            public void fire(OwCMISVersionEventListener listener_p) throws OwException
            {
                listener_p.versionCheckedIn(resourceId_p, versionSeriesId_p, currentObject_p, oldVersionId_p);
            }

        };
        versionEventBroker.fire(resourceId_p, versionSeriesId_p, eventHandler);
    }
}
