package com.wewebu.ow.server.ecmimpl.cmis.broker;

import java.util.HashMap;
import java.util.Map;

import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISResourceBroker.
 * Broker/Helper class for the OwCMISObjectBroker to manage
 * the different handler depending on the given resource id.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISResourceBroker<L>
{
    private Map<String, OwCMISMapBroker<L>> brokersMap = new HashMap<String, OwCMISMapBroker<L>>();

    public OwCMISResourceBroker()
    {
    }

    /**
    * Register the listeners to the given brokerId if the broker already exist, else
    * a new Broker instance will be created for given resource id. 
    * @param resourceId_p String representing the resource id
    * @param brokerId_p
    * @param listenerHandler_p
    */
    public synchronized void register(String resourceId_p, String brokerId_p, OwCMISListenerHandler<L> listenerHandler_p)
    {
        OwCMISMapBroker<L> broker = this.brokersMap.get(resourceId_p);

        if (broker == null)
        {
            broker = new OwCMISMapBroker<L>();
            this.brokersMap.put(resourceId_p, broker);
        }

        broker.register(brokerId_p, listenerHandler_p);
    }

    /**
     * Delegation to specific broker with given handler, if a broker exist
     * for the given resource ID.
     * @param resourceId_p String resource id depending Broker to resource ID mapping
     * @param brokerId_p String identifying a &quot;broker list&quot; for delegation 
     * @param eventHandler_p OwCMISEventDispatch handler which should be used
     * @throws OwException
     */
    synchronized void fire(String resourceId_p, String brokerId_p, OwCMISEventDispatch<L> eventHandler_p) throws OwException
    {
        OwCMISMapBroker<L> broker = this.brokersMap.get(resourceId_p);

        if (broker != null)
        {
            broker.fire(brokerId_p, eventHandler_p);
        }
    }

}
