package com.wewebu.ow.server.ecmimpl.cmis.broker;

import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISVersionEventListener.
 * Interface which should be implemented by a class, to receive
 * the events if version changes occurs.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISVersionEventListener
{
    void versionCheckedOut(String resourceId_p, String versionSeriesId_p, CmisObjectType pwcObject_p, String oldVersionId_p) throws OwException;

    void versionCanceledChenckedOut(String resourceId_p, String versionSeriesId_p, CmisObjectType currentObject_p, String pwcVersionId_p) throws OwException;

    void versionCheckedIn(String resourceId_p, String versionSeriesId_p, CmisObjectType currentObject_p, String pwcVersionId_p) throws OwException;

    void versionSaved(String resourceId_p, String versionSeriesId_p, CmisObjectType currentObject_p, String oldVersionId_p) throws OwException;
}
