package com.wewebu.ow.server.ecmimpl.cmis.content;

import java.util.Collection;
import java.util.LinkedList;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * CMIS implementation of a content collection.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@see OwContentCollection
 */
public class OwCMISContentCollection implements OwContentCollection
{
    private static Logger LOG = OwLog.getLogger(OwCMISContentCollection.class);

    private LinkedList<OwCMISContentElement> collection;
    private OwCMISObjectBase object;
    private OwCMISNetwork network;

    public OwCMISContentCollection(OwCMISObjectBase object_p, OwCMISNetwork network_p) throws OwException
    {
        this.collection = new LinkedList<OwCMISContentElement>();
        this.network = network_p;
        this.object = object_p;

        try
        {
            ObjectServicePort objsectServicePort = this.network.getObjectServicePort();
            CmisContentStreamType streams = objsectServicePort.getContentStream(this.object.getResourceID(), this.object.getDecodedID(), null, null, null, null);
            OwCMISContentElement elem = new OwCMISContentElement(network_p, streams, collection.size() + 1);
            collection.add(elem);
        }
        catch (CmisException e)
        {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e);
            LOG.error("OwCMISContentCollection.OwCMISContentCollection(): Could not initialize a content collection! A CMIS error occurred :  " + catcher.getLogMessage(), e);
            throw catcher.toOwException(this.network.getContext().localize("ecmimpl.cmis.OwCMISContentCollection.init.error", "An error occurred while initializing a content collection!"));
        }

    }

    public OwContentElement getContentElement(int contentType_p, int page_p) throws OwException
    {
        if (contentType_p != OwContentCollection.CONTENT_TYPE_DOCUMENT)
        {
            LOG.error("OwCMISContentCollection.getContentElement():Invalid content type request!Content request is not from type OwContentCollection.CONTENT_TYPE_DOCUMENT!");
            throw new OwInvalidOperationException(this.network.getContext().localize("ecmimpl.cmis.OwCMISContentCollection.invalid.content.type.request.error", "Invalid content type request!"));
        }

        try
        {
            return this.collection.get(page_p - 1);
        }
        catch (IndexOutOfBoundsException ex)
        {
            LOG.fatal("OwCMISContentCollection.getContentElement():Content page index " + page_p + " out of bounds " + this.collection.size() + "!", ex);
            throw new OwInvalidOperationException(this.network.getContext().localize1("ecmimpl.cmis.OwCMISContentCollection.content.page.index.error", "Invalid content page index %1!", "" + page_p), ex);
        }
    }

    public Collection<Integer> getContentTypes() throws OwException
    {
        LinkedList<Integer> ret = new LinkedList<Integer>();

        ret.add(Integer.valueOf(OwContentCollection.CONTENT_TYPE_DOCUMENT));

        return ret;
    }

    public int getPageCount() throws OwException
    {
        return collection.size();
    }
}
