package com.wewebu.ow.server.ecmimpl.cmis.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwContentElementDataSource implements the DataSource interface to
 * transfer content stream in service calls.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISContentElementDataSource implements DataSource
{
    private static Logger LOG = OwLog.getLogger(OwCMISContentElementDataSource.class);

    /**Save a DataSource into the MessageContext to provide Content as SOAP-Attachment
     * @since 3.1.0.0*/
    public static final String DATASOURCE_CONTENT_KEY = "CMIS_CONTENT_TRANSFER";

    private String mimeType;
    private OwContentElement content;
    private String name;

    public OwCMISContentElementDataSource(OwContentElement elem_p, String name_p) throws OwException
    {
        this(elem_p, name_p, null);
    }

    public OwCMISContentElementDataSource(OwContentElement elem_p, String name_p, String mimeType_p) throws OwException
    {
        this.content = elem_p;
        this.name = name_p;
        if (mimeType_p == null)
        {
            try
            {
                this.mimeType = elem_p.getMIMEType();
            }
            catch (OwException e)
            {
                throw e;
            }
            catch (Exception ex)
            {
                LOG.fatal("OwCMISContentElementDataSource.<init>:Invalid content element! Could not retrieve MIME type from content element!", ex);
                throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISContentElementDataSource.invalid.element.error", "Invalid content element!"), ex);
            }
        }
        else
        {
            this.mimeType = mimeType_p;
        }
    }

    public String getContentType()
    {
        //This method should at least return application/octet-stream if mimeType is null
        String contentType = this.mimeType == null ? "application/octet-stream" : this.mimeType;
        return contentType;
    }

    public InputStream getInputStream() throws IOException
    {
        try
        {
            return this.content.getContentStream(null);
        }
        catch (Exception e)
        {
            LOG.fatal("OwCMISContentElementDataSource.getInputStream: Could not access content stream!", e);
            throw new IOException("Could not access content stream!");
        }
    }

    public String getName()
    {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException
    {
        LOG.fatal("OwCMISContentElementDataSource.getOutputStream: Unsupported  content element data source operation!");
        throw new IOException("OwContentElementDataSource.getOutputStream: is not supported");
    }

}
