package com.wewebu.ow.server.ecmimpl.cmis.content;

import javax.activation.DataHandler;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISContentConveter;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwCMISStandardContentConverter.
 * Helper class to convert the OwContentCollection to a CMIS specific CmisContentStreamType.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStandardContentConverter implements OwCMISContentConveter
{
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardContentConverter.class);

    public OwCMISStandardContentConverter()
    {
        super();
    }

    public CmisContentStreamType createCmisContentStream(OwContentCollection contentCollection_p) throws OwException
    {
        try
        {
            if (contentCollection_p == null || contentCollection_p.getPageCount() == 0)
            {
                return null;
            }
        }
        catch (OwException owEx)
        {
            throw owEx;
        }
        catch (Exception e)
        {
            LOG.fatal("OwCMISStandardContentConverter.createCmisContentStream(): Invalid content collection! Could not retrieve content page count!", e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardContentConverter.invalid.content.collection.error", "Invalid content collection! "), e);
        }

        OwContentElement elem = null;
        try
        {
            elem = contentCollection_p.getContentElement(OwContentCollection.CONTENT_TYPE_DOCUMENT, 1);
        }
        catch (OwException owEx)
        {
            throw owEx;
        }
        catch (Exception e)
        {
            LOG.fatal("OwCMISStandardContentConverter.createCmisContentStream(): Invalid content collection! Could not retrieve content element!", e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardContentConverter.invalid.content.collection.error", "Invalid content collection! "), e);
        }

        OwCMISContentElementDataSource ds = null;
        ds = new OwCMISContentElementDataSource(elem, getElementName(elem));

        CmisContentStreamType stream = new CmisContentStreamType();
        stream.setFilename(ds.getName());
        stream.setMimeType(ds.getContentType());
        stream.setStream(new DataHandler(ds));

        return stream;
    }

    private String getElementName(OwContentElement contentElement_p) throws OwException
    {
        try
        {
            String name = null;
            name = contentElement_p.getMIMEParameter();//getContentFilePath();
            if (name != null)
            {
                name = name.replace('\\', '/');
                name = name.substring(name.indexOf('=') + 1);
            }
            return name;
        }
        catch (OwException owEx)
        {
            throw owEx;
        }
        catch (Exception ex)
        {
            LOG.fatal("OwCMISStandardContentConverter.getElementName(): Could not create content element name !", ex);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardContentConverter.content.name.error", "Could not create content element name !"), ex);
        }
    }
}
