package com.wewebu.ow.server.ecmimpl.cmis.extension;

/**
 *<p>
 * Extension libraries provide id based extensions.
 * <br/>
 * Extensions are aspect-oriented like , id based cross-cutting concerns.<br/>
 * Extensions are provided by extension libraries - {@link OwCMISExtensionLibrary} - and implemented as 
 * interface methods. Extensions are uniquely determined by implementing interface type and extension id.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public interface OwCMISExtensionLibrary
{
    /**
     * Retrieves extensions uniquely determined by implementing interface type and extension id.
     * @param <E>
     * @param extensionId_p id of the extension 
     * @param extensionInterface_p
     * @return the interface implementing extension module of 
     *         type E that provides the extension with the requested id  
     */
    <E> E getExtension(String extensionId_p, Class<E> extensionInterface_p);
}
