package com.wewebu.ow.server.ecmimpl.cmis.extension;

import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Network based extension interface.
 * <br/>
 * Extensions are aspect-oriented like , id based cross-cutting concerns.<br/>
 * Extensions are provided by extension libraries - {@link OwCMISExtensionLibrary} - and implemented as 
 * interface methods. Extensions are uniquely determined by implementing interface type and extension id.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public interface OwCMISNetworkExtension
{
    /** Extension point name for tweak object*/
    public static final String TWEAK_OBJECT_EP = "cmis.network.tweak.object";
    /** Extension point name for prepare object class
     * @since 3.2.0.0*/
    public static final String PREPARE_OBJECT_CLASS_EP = "cmis.network.prepare.objectClass";
    /** Extension point name for prepare object class for creation
     * @since 3.2.0.0*/
    public static final String PREPARE_FOR_CREATION_EP = "cmis.network.prepare.object.creation";

    /**
     * Makes structural adjustments (egg. property id changes, property value changes) to CMIS object
     * that is part of a search (query) result.
     * @param object_p the search resulted CMIS object - for performance purposes might be an in-out parameter
     * @param statement_p the search statement that produced the given object
     * @param network_p the current network
     * @return the structural adjusted object
     * @throws OwException
     */
    CmisObjectType tweakSearchResult(CmisObjectType object_p, OwQueryStatement statement_p, OwCMISNetwork network_p) throws OwException;

    /**
     * Prepare object class, load additional information or wrap into a specific handler.
     * @param class_p OwCMISObjectClass to be prepared
     * @param network_p OwCMISNetwork current instance
     * @return OwCMISObjectClass
     * @throws OwException in case of problems during prepare
     * @since 3.2.0.0
     */
    OwCMISObjectClass prepareObjectClass(OwCMISObjectClass class_p, OwCMISNetwork network_p) throws OwException;

    /**
     * Prepare object class to be used in skeleton object (begin of Creation Process).
     * @param objectClass_p OwCMISObjectClass current created skeleton
     * @param network_p OwCMISNetwork current instance
     * @return OwCMISObjectClass which was &quot;prepared&quot; for Creation process
     * @throws OwException in case of problems during prepare
     * @since 3.2.0.0 
     */
    OwCMISObjectClass prepareForCreation(OwCMISObjectClass objectClass_p, OwCMISNetwork network_p) throws OwException;
}
