package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceBoolean;

/**
 *<p>
 * OwCMISBooleanChoiceBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISBooleanChoiceBinding implements OwCMISChoiceBinding<Boolean>
{
    private CmisChoiceBoolean nativeChoice;

    public OwCMISBooleanChoiceBinding(CmisChoiceBoolean choice_p)
    {
        this.nativeChoice = choice_p;
    }

    public List<OwCMISChoiceBinding<Boolean>> getSubChoices()
    {
        List<CmisChoiceBoolean> choices = this.nativeChoice.getChoice();
        List<OwCMISChoiceBinding<Boolean>> subChoiceBindings = new LinkedList<OwCMISChoiceBinding<Boolean>>();
        for (CmisChoiceBoolean subChoice : choices)
        {
            subChoiceBindings.add(new OwCMISBooleanChoiceBinding(subChoice));
        }
        return subChoiceBindings;
    }

    public List<Boolean> getValues()
    {
        return this.nativeChoice.getValue();
    }

    public CmisChoice getChoice()
    {
        return this.nativeChoice;
    }
}
