package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISBooleanPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISBooleanPropertyBinding implements OwCMISNativePropertyBinding<Boolean>
{
    private CmisPropertyBoolean propertyBoolean;

    public static final OwCMISBooleanPropertyBinding newBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyBoolean propertyBoolean = cmisFactory.createCmisPropertyBoolean();
        return new OwCMISBooleanPropertyBinding(propertyBoolean);
    }

    public OwCMISBooleanPropertyBinding(CmisPropertyBoolean propertyBoolean_p)
    {
        this.propertyBoolean = propertyBoolean_p;
    }

    public List<Boolean> getLiveValueList()
    {
        return propertyBoolean.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return propertyBoolean;
    }

    public OwCMISNativePropertyBinding<Boolean> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyBoolean clone = cmisFactory.createCmisPropertyBoolean();
        clone.getValue().addAll(this.propertyBoolean.getValue());
        clone.setPropertyDefinitionId(this.propertyBoolean.getPropertyDefinitionId());
        return new OwCMISBooleanPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }

}
