package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;

/**
 *<p>
 * OwCMISChoiceBinding.
 * Interface to create a choice element which is used
 * in choice list.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISChoiceBinding<L>
{
    /**
     * Returns the native CmisChoice object which was wrapped
     * by the implementing class.
     * @return CmisChoice
     */
    public CmisChoice getChoice();

    /**
     * Return a list of values for given choices, 
     * @return List of specific type &lt;L&gt; values.
     */
    public List<L> getValues();

    /**
     * If there is a tree like choice structure
     * this method returns a non-empty list of OwCMISChiceBinding's,
     * else an empty list should be returned.
     * @return List of OwCMISChiceBinding.
     */
    public List<OwCMISChoiceBinding<L>> getSubChoices();
}
