package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceDateTime;

/**
 *<p>
 * OwCMISDateTimeChoiceBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDateTimeChoiceBinding implements OwCMISChoiceBinding<XMLGregorianCalendar>
{
    private CmisChoiceDateTime nativeChoice;

    public OwCMISDateTimeChoiceBinding(CmisChoiceDateTime choice_p)
    {
        this.nativeChoice = choice_p;
    }

    public List<OwCMISChoiceBinding<XMLGregorianCalendar>> getSubChoices()
    {
        List<CmisChoiceDateTime> choices = this.nativeChoice.getChoice();
        List<OwCMISChoiceBinding<XMLGregorianCalendar>> subChoiceBindings = new LinkedList<OwCMISChoiceBinding<XMLGregorianCalendar>>();
        for (CmisChoiceDateTime subChoice : choices)
        {
            subChoiceBindings.add(new OwCMISDateTimeChoiceBinding(subChoice));
        }
        return subChoiceBindings;
    }

    public List<XMLGregorianCalendar> getValues()
    {
        return this.nativeChoice.getValue();
    }

    public CmisChoice getChoice()
    {
        return this.nativeChoice;
    }
}
