package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTime;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISDateTimePropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDateTimePropertyBinding implements OwCMISNativePropertyBinding<XMLGregorianCalendar>
{
    private CmisPropertyDateTime propertyDateTime;

    public OwCMISDateTimePropertyBinding(CmisPropertyDateTime propertyDateTime_p)
    {
        super();
        this.propertyDateTime = propertyDateTime_p;
    }

    public List<XMLGregorianCalendar> getLiveValueList()
    {
        return this.propertyDateTime.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyDateTime;
    }

    public OwCMISNativePropertyBinding<XMLGregorianCalendar> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyDateTime clone = cmisFactory.createCmisPropertyDateTime();
        clone.getValue().addAll(this.propertyDateTime.getValue());
        clone.setPropertyDefinitionId(this.propertyDateTime.getPropertyDefinitionId());
        return new OwCMISDateTimePropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}