package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceDecimal;

/**
 *<p>
 * OwCMISDecimalChoiceBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDecimalChoiceBinding implements OwCMISChoiceBinding<BigDecimal>
{
    private CmisChoiceDecimal nativeChoice;

    public OwCMISDecimalChoiceBinding(CmisChoiceDecimal choice_p)
    {
        this.nativeChoice = choice_p;
    }

    public List<OwCMISChoiceBinding<BigDecimal>> getSubChoices()
    {
        List<CmisChoiceDecimal> choices = this.nativeChoice.getChoice();
        List<OwCMISChoiceBinding<BigDecimal>> subChoiceBindings = new LinkedList<OwCMISChoiceBinding<BigDecimal>>();
        for (CmisChoiceDecimal subChoice : choices)
        {
            subChoiceBindings.add(new OwCMISDecimalChoiceBinding(subChoice));
        }
        return subChoiceBindings;
    }

    public List<BigDecimal> getValues()
    {
        return this.nativeChoice.getValue();
    }

    public CmisChoice getChoice()
    {
        return this.nativeChoice;
    }
}
