package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.math.BigDecimal;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimal;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISDecimalPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDecimalPropertyBinding implements OwCMISNativePropertyBinding<BigDecimal>
{
    private CmisPropertyDecimal propertyDecimal;

    public OwCMISDecimalPropertyBinding(CmisPropertyDecimal propertyDecimal_p)
    {
        super();
        this.propertyDecimal = propertyDecimal_p;
    }

    public List<BigDecimal> getLiveValueList()
    {
        return this.propertyDecimal.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyDecimal;
    }

    public OwCMISNativePropertyBinding<BigDecimal> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyDecimal clone = cmisFactory.createCmisPropertyDecimal();
        clone.getValue().addAll(this.propertyDecimal.getValue());
        clone.setPropertyDefinitionId(this.propertyDecimal.getPropertyDefinitionId());
        return new OwCMISDecimalPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}
