package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyHtml;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISHtmlPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISHtmlPropertyBinding implements OwCMISNativePropertyBinding<String>
{
    private CmisPropertyHtml propertyHtml;

    public OwCMISHtmlPropertyBinding(CmisPropertyHtml propertyHtml_p)
    {
        super();
        this.propertyHtml = propertyHtml_p;
    }

    public List<String> getLiveValueList()
    {
        return this.propertyHtml.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyHtml;
    }

    public OwCMISNativePropertyBinding<String> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyHtml clone = cmisFactory.createCmisPropertyHtml();
        clone.getValue().addAll(this.propertyHtml.getValue());
        clone.setPropertyDefinitionId(this.propertyHtml.getPropertyDefinitionId());
        return new OwCMISHtmlPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}
