package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceId;

/**
 *<p>
 * OwCMISIdChoiceBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISIdChoiceBinding implements OwCMISChoiceBinding<String>
{
    private CmisChoiceId nativeChoice;

    public OwCMISIdChoiceBinding(CmisChoiceId choice_p)
    {
        this.nativeChoice = choice_p;
    }

    public List<OwCMISChoiceBinding<String>> getSubChoices()
    {
        List<CmisChoiceId> choices = this.nativeChoice.getChoice();
        List<OwCMISChoiceBinding<String>> subChoiceBindings = new LinkedList<OwCMISChoiceBinding<String>>();
        for (CmisChoiceId subChoice : choices)
        {
            subChoiceBindings.add(new OwCMISIdChoiceBinding(subChoice));
        }
        return subChoiceBindings;
    }

    public List<String> getValues()
    {
        return this.nativeChoice.getValue();
    }

    public CmisChoice getChoice()
    {
        return this.nativeChoice;
    }
}
