package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * String CMIS id to {@link OwObject} converter.
 * @see OwCMISIdObjectConverterClass
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISIdObjectConverter implements OwCMISValueConverter<String, OwObject>
{
    private static final Logger LOG = OwLog.getLogger(OwCMISIdObjectConverter.class);

    private OwCMISNetwork network;
    private OwCMISValueConverter<String, String> dmsidConverter;
    private OwCMISIdObjectConverterClass converterClass;

    public OwCMISIdObjectConverter(OwCMISIdObjectConverterClass converterClass_p, OwCMISNetwork network_p, OwCMISValueConverter<String, String> dmsidConverter_p)
    {
        super();
        this.network = network_p;
        this.dmsidConverter = dmsidConverter_p;
        this.converterClass = converterClass_p;
    }

    public List<String> fromArrayValue(OwObject[] owdValue_p) throws OwInvalidOperationException
    {
        try
        {
            String[] owdDmsidValues = null;

            if (owdValue_p != null)
            {
                owdDmsidValues = new String[owdValue_p.length];
                for (int i = 0; i < owdDmsidValues.length; i++)
                {
                    owdDmsidValues[i] = owdValue_p[i].getDMSID();
                }

            }
            return this.dmsidConverter.fromArrayValue(owdDmsidValues);
        }
        catch (OwInvalidOperationException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISIdObjectConverter.fromArrayValue(): Could not retrieve DMSID !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdObjectConverter.invalid.object.error", "Invalid object !"), e);
        }
    }

    public List<String> fromValue(OwObject owdValue_p) throws OwInvalidOperationException
    {
        try
        {
            String owdDmsidValue = null;

            if (owdValue_p != null)
            {
                owdDmsidValue = owdValue_p.getDMSID();
            }
            return this.dmsidConverter.fromValue(owdDmsidValue);
        }
        catch (OwInvalidOperationException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISIdObjectConverter.fromArrayValue(): Could not retrieve DMSID !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdObjectConverter.invalid.object.error", "Invalid object !"), e);
        }
    }

    public OwCMISValueConverterClass<String, OwObject> getConverterClass()
    {
        return this.converterClass;
    }

    public OwObject[] toArrayValue(List<String> cmisValue_p) throws OwInvalidOperationException
    {
        try
        {
            String[] owdDmsidValues = this.dmsidConverter.toArrayValue(cmisValue_p);
            if (owdDmsidValues != null)
            {
                OwObject[] objects = new OwObject[owdDmsidValues.length];
                for (int i = 0; i < owdDmsidValues.length; i++)
                {
                    objects[i] = this.network.getObjectFromDMSID(owdDmsidValues[i], true);
                }
                return objects;
            }
            else
            {
                return null;
            }
        }
        catch (OwInvalidOperationException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISIdObjectConverter.toArrayValue(): Could create object from DMSID !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdObjectConverter.invalid.object.error", "Invalid object !"), e);
        }
    }

    public OwObject toValue(List<String> cmisValue_p) throws OwInvalidOperationException
    {
        try
        {
            String owdDmsidValue = this.dmsidConverter.toValue(cmisValue_p);
            if (owdDmsidValue != null)
            {
                OwObject objects = this.network.getObjectFromDMSID(owdDmsidValue, true);
                return objects;
            }
            else
            {
                return null;
            }
        }
        catch (OwInvalidOperationException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISIdObjectConverter.toValue(): Could create object from DMSID !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdObjectConverter.invalid.object.error", "Invalid object !"), e);
        }
    }

}
