package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * String CMIS id to {@link OwObject} converter class.
 * @see OwCMISIdObjectConverter
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISIdObjectConverterClass implements OwCMISValueConverterClass<String, OwObject>
{
    private static final Logger LOG = OwLog.getLogger(OwCMISIdObjectConverterClass.class);

    private OwCMISValueConverterClass<String, String> dmisdConverterClass;

    public OwCMISIdObjectConverterClass(OwCMISValueConverterClass<String, String> dmisdConverterClass_p)
    {
        super();
        this.dmisdConverterClass = dmisdConverterClass_p;
    }

    public Class<OwObject> getOClass()
    {
        return OwObject.class;
    }

    public OwCMISValueConverter<String, OwObject> newConverter(OwCMISNetwork network_p)
    {
        return new OwCMISIdObjectConverter(this, network_p, this.dmisdConverterClass.newConverter(network_p));
    }

    public OwObject[] toStaticArrayValue(List<String> cmisValue_p) throws OwInvalidOperationException
    {
        LOG.error("OwCMISIdObjectConverterClass.toStaticValue: Invalid CMIS object ID: could not perform ID to Workdesk object conversion...");
        throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdObjectConverterClass.invalid.conversion.error", "Invalid CMIS object ID: could not perform ID to Workdesk object conversion"));
    }

    public OwObject toStaticValue(List<String> cmisValue_p) throws OwInvalidOperationException
    {
        LOG.error("OwCMISIdObjectConverterClass.toStaticValue: Invalid CMIS object ID: could not perform ID to Workdesk object conversion...");
        throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdObjectConverterClass.invalid.conversion.error", "Invalid CMIS object ID: could not perform ID to Workdesk object conversion"));
    }

}
