package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyId;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISIdPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISIdPropertyBinding implements OwCMISNativePropertyBinding<String>
{
    private CmisPropertyId propertyId;

    public OwCMISIdPropertyBinding(CmisPropertyId propertyId_p)
    {
        super();
        this.propertyId = propertyId_p;
    }

    public List<String> getLiveValueList()
    {
        return this.propertyId.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyId;
    }

    public OwCMISNativePropertyBinding<String> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyId clone = cmisFactory.createCmisPropertyId();
        clone.getValue().addAll(this.propertyId.getValue());
        clone.setPropertyDefinitionId(this.propertyId.getPropertyDefinitionId());
        return new OwCMISIdPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}
