package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceInteger;

/**
 *<p>
 * OwCMISIntegerChoiceBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISIntegerChoiceBinding implements OwCMISChoiceBinding<BigInteger>
{
    private CmisChoiceInteger nativeChoice;

    public OwCMISIntegerChoiceBinding(CmisChoiceInteger choice_p)
    {
        this.nativeChoice = choice_p;
    }

    public List<OwCMISChoiceBinding<BigInteger>> getSubChoices()
    {
        List<CmisChoiceInteger> choices = this.nativeChoice.getChoice();
        List<OwCMISChoiceBinding<BigInteger>> subChoiceBindings = new LinkedList<OwCMISChoiceBinding<BigInteger>>();
        for (CmisChoiceInteger subChoice : choices)
        {
            subChoiceBindings.add(new OwCMISIntegerChoiceBinding(subChoice));
        }
        return subChoiceBindings;
    }

    public List<BigInteger> getValues()
    {
        return this.nativeChoice.getValue();
    }

    public CmisChoice getChoice()
    {
        return this.nativeChoice;
    }
}
