package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.math.BigInteger;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyInteger;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISIntegerPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISIntegerPropertyBinding implements OwCMISNativePropertyBinding<BigInteger>
{
    private CmisPropertyInteger propertyInteger;

    public OwCMISIntegerPropertyBinding(CmisPropertyInteger propertyInteger_p)
    {
        super();
        this.propertyInteger = propertyInteger_p;
    }

    public List<BigInteger> getLiveValueList()
    {
        return this.propertyInteger.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyInteger;
    }

    public OwCMISNativePropertyBinding<BigInteger> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyInteger clone = cmisFactory.createCmisPropertyInteger();
        clone.getValue().addAll(this.propertyInteger.getValue());
        clone.setPropertyDefinitionId(this.propertyInteger.getPropertyDefinitionId());
        return new OwCMISIntegerPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}
