package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwCMISLiveListHandler.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISLiveListHandler<L, O>
{
    private static final Logger LOG = OwLog.getLogger(OwCMISLiveListHandler.class);

    private OwCMISValueConverter<L, O> liveValueConverter;
    private OwCMISValueConverterClass<L, O> liveValueConverterClass;

    public OwCMISLiveListHandler(OwCMISValueConverter<L, O> liveValueConverter_p)
    {
        super();
        this.liveValueConverter = liveValueConverter_p;
        this.liveValueConverterClass = this.liveValueConverter.getConverterClass();
    }

    public Object extractValue(List<L> liveList_p, boolean isArray_p) throws OwInvalidOperationException
    {
        if (!liveList_p.isEmpty())
        {
            if (isArray_p)
            {
                return this.liveValueConverter.toArrayValue(liveList_p);
            }
            else
            {
                return this.liveValueConverter.toValue(liveList_p);
            }
        }
        else
        {
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    public void replaceListValues(List<L> liveList_p, Object value_p, boolean isArray_p) throws OwInvalidOperationException
    {
        if (value_p != null)
        {
            Class<? extends Object> valueClass = value_p.getClass();
            if (isArray_p)
            {
                if (valueClass.isArray())
                {
                    Class<?> arrayComponentClass = valueClass.getComponentType();

                    if (this.liveValueConverterClass.getOClass().isAssignableFrom(arrayComponentClass))
                    {
                        O[] oValue = (O[]) value_p;
                        List<L> lValue = this.liveValueConverter.fromArrayValue(oValue);
                        liveList_p.clear();
                        liveList_p.addAll(lValue);
                    }
                    else
                    {
                        if (value_p instanceof Object[])
                        {
                            Object[] objArr = (Object[]) value_p;
                            liveList_p.clear();
                            for (int i = 0; i < objArr.length; i++)
                            {
                                if (objArr[i] != null)
                                {
                                    liveList_p.addAll(this.liveValueConverter.fromValue((O) objArr[i]));
                                }
                                else
                                {
                                    liveList_p.add(null);
                                }
                            }
                        }
                        else
                        {
                            String msg = "Invalid array component type ! " + this.liveValueConverterClass.getOClass().getName() + "[] expected ! " + valueClass.getComponentType().getName() + "[] found istead!";
                            LOG.error("OwCMISLiveListHandler.setValue():" + msg);
                            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISLiveListHandler.invalid.array.component.error", "Invalid array component type! "));
                        }
                    }
                }
                else
                {
                    String msg = "Invalid non array value! Array value expected !" + valueClass + " found instead!";
                    LOG.error("OwCMISLiveListHandler.setValue():" + msg);
                    throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISLiveListHandler.array.expected.error", "Array value expected!"));
                }
            }
            else
            {
                if (this.liveValueConverterClass.getOClass().isAssignableFrom(valueClass))
                {
                    O oValue = (O) value_p;
                    List<L> lValue = this.liveValueConverter.fromValue(oValue);
                    liveList_p.clear();
                    liveList_p.addAll(lValue);
                }
                else
                {
                    String msg = "Invalid value type ! " + liveValueConverterClass.getOClass().getName() + " expected ! " + valueClass.getName() + " found instead!";
                    LOG.error("OwCMISLiveListHandler.setValue():" + msg);
                    throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISLiveListHandler.invalid.value.type.error", "Invalid value!"));
                }
            }
        }
        else
        {
            liveList_p.clear();
        }
    }
}
