package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;

/**
 *<p>
 * OwCMISNativePropertyBinding.
 * Interface defining the methods for native value handling.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISNativePropertyBinding<L> extends Cloneable
{
    /**
     * Return a list of native property values if exist,
     * else an empty list should be returned.
     * @return List of specific type &lt;L&gt;
     */
    List<L> getLiveValueList();

    /**
     * Return the native CmisProperty
     * which was retrieved through the services.
     * @return CmisProperty
     */
    CmisProperty getNativeProperty();

    /**
     * Clone method which should return a cloned
     * instance of current instance.
     * @return OwCMISNativeProeprtyBinding
     */
    OwCMISNativePropertyBinding<L> cloneBinding();
}
