package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBooleanDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyBooleanDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyBooleanDefinition extends OwCMISPropertyDefinitionBase<Boolean, CmisPropertyBoolean>
{
    private CmisPropertyBooleanDefinitionType nativeDefinition;

    public OwCMISPropertyBooleanDefinition(CmisPropertyBooleanDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyBoolean.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<Boolean>> getChoice()
    {
        List<CmisChoiceBoolean> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<Boolean>> choiceBindings = new LinkedList<OwCMISChoiceBinding<Boolean>>();
        for (CmisChoiceBoolean choice : choices)
        {
            OwCMISBooleanChoiceBinding choiceBinding = new OwCMISBooleanChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    public Boolean getMaxValue()
    {
        return null;
    }

    public Boolean getMinValue()
    {
        return null;
    }

    @Override
    protected CmisPropertyBoolean createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyBoolean();
    }

    @Override
    protected OwCMISNativePropertyBinding<Boolean> createTypedBoundProperty(CmisPropertyBoolean cmisProperty_p)
    {
        return new OwCMISBooleanPropertyBinding(cmisProperty_p);
    }

}
