package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceDateTime;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTime;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTimeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyDateTimeDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyDateTimeDefinition extends OwCMISPropertyDefinitionBase<XMLGregorianCalendar, CmisPropertyDateTime>
{
    private CmisPropertyDateTimeDefinitionType nativeDefinition;

    public OwCMISPropertyDateTimeDefinition(CmisPropertyDateTimeDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyDateTime.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<XMLGregorianCalendar>> getChoice()
    {
        List<CmisChoiceDateTime> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<XMLGregorianCalendar>> choiceBindings = new LinkedList<OwCMISChoiceBinding<XMLGregorianCalendar>>();
        for (CmisChoiceDateTime choice : choices)
        {
            OwCMISDateTimeChoiceBinding choiceBinding = new OwCMISDateTimeChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    public XMLGregorianCalendar getMaxValue()
    {
        return null;
    }

    public XMLGregorianCalendar getMinValue()
    {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    protected CmisPropertyDateTime createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyDateTime();
    }

    @Override
    protected OwCMISNativePropertyBinding<XMLGregorianCalendar> createTypedBoundProperty(CmisPropertyDateTime cmisProperty_p)
    {
        return new OwCMISDateTimePropertyBinding(cmisProperty_p);
    }

}
