package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceDecimal;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimal;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimalDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyDecimalDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyDecimalDefinition extends OwCMISPropertyDefinitionBase<BigDecimal, CmisPropertyDecimal>
{
    private CmisPropertyDecimalDefinitionType nativeDefinition;

    public OwCMISPropertyDecimalDefinition(CmisPropertyDecimalDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyDecimal.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<BigDecimal>> getChoice()
    {
        List<CmisChoiceDecimal> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<BigDecimal>> choiceBindings = new LinkedList<OwCMISChoiceBinding<BigDecimal>>();
        for (CmisChoiceDecimal choice : choices)
        {
            OwCMISDecimalChoiceBinding choiceBinding = new OwCMISDecimalChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    @Override
    protected CmisPropertyDecimal createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyDecimal();
    }

    @Override
    protected OwCMISDecimalPropertyBinding createTypedBoundProperty(CmisPropertyDecimal cmisProperty_p)
    {
        return new OwCMISDecimalPropertyBinding(cmisProperty_p);
    }

    public BigDecimal getMaxValue()
    {
        return nativeDefinition.getMaxValue();
    }

    public BigDecimal getMinValue()
    {
        return nativeDefinition.getMinValue();
    }

}
