package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * OwCMISPropertyDefinition.
 * Interface for handling the native property definition instances.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISPropertyDefinition<L>
{
    /**
     * Return the native type definition object.
     * @return CmisPropertyDefinitionType
     */
    CmisPropertyDefinitionType getNativeDefinition();

    /**
     * Return a list of OwCMISChoiceBinding, if defining
     * a choice list.
     * @return List of OwCMISChoiceBindings
     * @see OwCMISChoiceBinding
     */
    List<OwCMISChoiceBinding<L>> getChoice();

    /**
     * Factory interface to create a binding out from given CmisProperty  
     * @param cmisProperty_p CmisProperty, non-null 
     * @return OwCMISNativePropertyBinding
     * @throws OwInvalidOperationException if the native binding could not be created
     * @see OwCMISNativePropertyBinding
     */
    OwCMISNativePropertyBinding<L> createBoundProperty(CmisProperty cmisProperty_p) throws OwInvalidOperationException;

    /**
     * Return a maximum value if exist, else null should be returned.
     * <p>For type String this method will return null every time</p>
     * @return &lt;L&gt; type value or null
     */
    L getMaxValue();

    /**
     * Return a minimum value if exist, else null should be returned.
     * <p>For type String this method will return null every time</p>
     * @return &lt;L&gt; type value or null
     */
    L getMinValue();
}
