package com.wewebu.ow.server.ecmimpl.cmis.generic;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwCMISPropertyDefinitionBase.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public abstract class OwCMISPropertyDefinitionBase<L, P extends CmisProperty> implements OwCMISPropertyDefinition<L>
{
    private static Logger LOG = OwLog.getLogger(OwCMISPropertyDefinitionBase.class);

    private Class<P> propertyClass;

    public OwCMISPropertyDefinitionBase(Class<P> propertyClass_p)
    {
        this.propertyClass = propertyClass_p;
    }

    protected abstract P createNativeProperty();

    protected abstract OwCMISNativePropertyBinding<L> createTypedBoundProperty(P cmisProperty_p);

    @SuppressWarnings("unchecked")
    public final OwCMISNativePropertyBinding<L> createBoundProperty(CmisProperty cmisProperty_p) throws OwInvalidOperationException
    {
        P property = null;

        if (cmisProperty_p == null)
        {
            property = createNativeProperty();
        }
        else
        {
            if (this.propertyClass.isAssignableFrom(cmisProperty_p.getClass()))
            {
                property = (P) cmisProperty_p;
            }
            else
            {
                String msg = "Invalid native property " + cmisProperty_p.getPropertyDefinitionId() + " type " + cmisProperty_p.getClass().getName() + " for " + propertyClass.getName() + " was expected";
                LOG.error("OwCMISPropertyDefinitionBase.createBoundProperty():" + msg);
                throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISPropertyDefinitionBase.invalid.native.property.error", "Invalid property!"));
            }
        }

        CmisPropertyDefinitionType definition = getNativeDefinition();
        property.setPropertyDefinitionId(definition.getId());
        return createTypedBoundProperty(property);
    }
}
