package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceHtml;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyHtml;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyHtmlDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyHtmlDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyHtmlDefinition extends OwCMISPropertyDefinitionBase<String, CmisPropertyHtml>
{
    private CmisPropertyHtmlDefinitionType nativeDefinition;

    public OwCMISPropertyHtmlDefinition(CmisPropertyHtmlDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyHtml.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<String>> getChoice()
    {
        List<CmisChoiceHtml> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<String>> choiceBindings = new LinkedList<OwCMISChoiceBinding<String>>();
        for (CmisChoiceHtml choice : choices)
        {
            OwCMISHtmlChoiceBinding choiceBinding = new OwCMISHtmlChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    @Override
    protected CmisPropertyHtml createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyHtml();
    }

    @Override
    protected OwCMISHtmlPropertyBinding createTypedBoundProperty(CmisPropertyHtml cmisProperty_p)
    {
        return new OwCMISHtmlPropertyBinding(cmisProperty_p);
    }

    public String getMaxValue()
    {
        return null;
    }

    public String getMinValue()
    {
        return null;
    }

}
