package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceId;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyId;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIdDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyIdDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyIdDefinition extends OwCMISPropertyDefinitionBase<String, CmisPropertyId>
{
    private CmisPropertyIdDefinitionType nativeDefinition;

    public OwCMISPropertyIdDefinition(CmisPropertyIdDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyId.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<String>> getChoice()
    {
        List<CmisChoiceId> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<String>> choiceBindings = new LinkedList<OwCMISChoiceBinding<String>>();
        for (CmisChoiceId choice : choices)
        {
            OwCMISIdChoiceBinding choiceBinding = new OwCMISIdChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    public String getMaxValue()
    {
        return null;
    }

    public String getMinValue()
    {
        return null;
    }

    @Override
    protected CmisPropertyId createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyId();
    }

    @Override
    protected OwCMISIdPropertyBinding createTypedBoundProperty(CmisPropertyId cmisProperty_p)
    {
        return new OwCMISIdPropertyBinding(cmisProperty_p);
    }

}
