package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceInteger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyInteger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyIntegerDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyIntegerDefinition extends OwCMISPropertyDefinitionBase<BigInteger, CmisPropertyInteger>
{
    private CmisPropertyIntegerDefinitionType nativeDefinition;

    public OwCMISPropertyIntegerDefinition(CmisPropertyIntegerDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyInteger.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<BigInteger>> getChoice()
    {
        List<CmisChoiceInteger> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<BigInteger>> choiceBindings = new LinkedList<OwCMISChoiceBinding<BigInteger>>();
        for (CmisChoiceInteger choice : choices)
        {
            OwCMISIntegerChoiceBinding choiceBinding = new OwCMISIntegerChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    public BigInteger getMaxValue()
    {
        return nativeDefinition.getMaxValue();
    }

    public BigInteger getMinValue()
    {
        return nativeDefinition.getMinValue();
    }

    @Override
    protected CmisPropertyInteger createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyInteger();
    }

    @Override
    protected OwCMISIntegerPropertyBinding createTypedBoundProperty(CmisPropertyInteger cmisProperty_p)
    {
        return new OwCMISIntegerPropertyBinding(cmisProperty_p);
    }
}
