package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceString;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyString;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyStringDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyStringDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyStringDefinition extends OwCMISPropertyDefinitionBase<String, CmisPropertyString>
{
    private CmisPropertyStringDefinitionType nativeDefinition;

    public OwCMISPropertyStringDefinition(CmisPropertyStringDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyString.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<String>> getChoice()
    {
        List<CmisChoiceString> choices = this.nativeDefinition.getChoice();

        Collections.sort(choices, new Comparator() {

            public int compare(Object o1_p, Object o2_p)
            {
                CmisChoiceString p1 = (CmisChoiceString) o1_p;
                CmisChoiceString p2 = (CmisChoiceString) o2_p;
                return p1.getDisplayName().compareToIgnoreCase(p2.getDisplayName());
            }

        });

        List<OwCMISChoiceBinding<String>> choiceBindings = new LinkedList<OwCMISChoiceBinding<String>>();

        for (CmisChoiceString choice : choices)
        {
            OwCMISStringChoiceBinding choiceBinding = new OwCMISStringChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    public String getMaxValue()
    {
        return null;
    }

    public String getMinValue()
    {
        return null;
    }

    @Override
    protected CmisPropertyString createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyString();
    }

    @Override
    protected OwCMISStringPropertyBinding createTypedBoundProperty(CmisPropertyString cmisProperty_p)
    {
        return new OwCMISStringPropertyBinding(cmisProperty_p);
    }

}
