package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceUri;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyUri;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyUriDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISPropertyUriDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyUriDefinition extends OwCMISPropertyDefinitionBase<String, CmisPropertyUri>
{
    private CmisPropertyUriDefinitionType nativeDefinition;

    public OwCMISPropertyUriDefinition(CmisPropertyUriDefinitionType nativeDefinition_p)
    {
        super(CmisPropertyUri.class);
        this.nativeDefinition = nativeDefinition_p;
    }

    public List<OwCMISChoiceBinding<String>> getChoice()
    {
        List<CmisChoiceUri> choices = this.nativeDefinition.getChoice();
        List<OwCMISChoiceBinding<String>> choiceBindings = new LinkedList<OwCMISChoiceBinding<String>>();
        for (CmisChoiceUri choice : choices)
        {
            OwCMISUriChoiceBinding choiceBinding = new OwCMISUriChoiceBinding(choice);
            choiceBindings.add(choiceBinding);
        }
        return choiceBindings;
    }

    public CmisPropertyDefinitionType getNativeDefinition()
    {
        return this.nativeDefinition;
    }

    public String getMaxValue()
    {
        return null;
    }

    public String getMinValue()
    {
        return null;
    }

    @Override
    protected CmisPropertyUri createNativeProperty()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        return cmisFactory.createCmisPropertyUri();
    }

    @Override
    protected OwCMISUriPropertyBinding createTypedBoundProperty(CmisPropertyUri cmisProperty_p)
    {
        return new OwCMISUriPropertyBinding(cmisProperty_p);
    }

}
