package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyString;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISStringPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStringPropertyBinding implements OwCMISNativePropertyBinding<String>
{
    private CmisPropertyString propertyString;

    public OwCMISStringPropertyBinding(CmisPropertyString propertyString_p)
    {
        super();
        this.propertyString = propertyString_p;
    }

    public List<String> getLiveValueList()
    {
        return this.propertyString.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyString;
    }

    public OwCMISNativePropertyBinding<String> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyString clone = cmisFactory.createCmisPropertyString();
        clone.getValue().addAll(this.propertyString.getValue());
        clone.setPropertyDefinitionId(this.propertyString.getPropertyDefinitionId());
        return new OwCMISStringPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}
