package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyUri;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

/**
 *<p>
 * OwCMISUriPropertyBinding.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISUriPropertyBinding implements OwCMISNativePropertyBinding<String>
{
    private CmisPropertyUri propertyUri;

    public OwCMISUriPropertyBinding(CmisPropertyUri propertyUri_p)
    {
        super();
        this.propertyUri = propertyUri_p;
    }

    public List<String> getLiveValueList()
    {
        return this.propertyUri.getValue();
    }

    public CmisProperty getNativeProperty()
    {
        return this.propertyUri;
    }

    public OwCMISNativePropertyBinding<String> cloneBinding()
    {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyUri clone = cmisFactory.createCmisPropertyUri();
        clone.getValue().addAll(this.propertyUri.getValue());
        clone.setPropertyDefinitionId(this.propertyUri.getPropertyDefinitionId());
        return new OwCMISUriPropertyBinding(clone);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return cloneBinding();
    }
}
