package com.wewebu.ow.server.ecmimpl.cmis.generic;

import java.util.List;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * OwCMISValueConverter type/class object.
 * Interface for conversion-definitions  from type L (base) to O (resulting), and also 
 * to transform from array to list collections.
 * A static/class definition of {@link OwCMISValueConverter}s.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISValueConverterClass<L, O>
{
    /**
     * Return the java.lang.Class which should be the 
     * resulting type at end of conversion.
     * @return Class
     */
    Class<O> getOClass();

    /**
     * 
     * @param network_p the {@link OwCMISNetwork} that the resulting converter depends on
     * @return a converter object corresponding to this converter-class object   
     */
    OwCMISValueConverter<L, O> newConverter(OwCMISNetwork network_p);

    /**
     * Return a statically-created (non {@link OwCMISNetwork} depended)
     * representation of the given List as type O or simply converts the 
     * first entry of the list into the resulting type.
     * @param cmisValue_p List of values to convert
     * @return Resulting type or null
     * @throws OwInvalidOperationException
     */
    O toStaticValue(List<L> cmisValue_p) throws OwInvalidOperationException;

    /**
     * Statically converts the list into an array of the resulting type.
     * The conversion is non {@link OwCMISNetwork} depended.
     * @param cmisValue_p List to be converted
     * @return Array type O, or null
     * @throws OwInvalidOperationException
     */
    O[] toStaticArrayValue(List<L> cmisValue_p) throws OwInvalidOperationException;
}
