package com.wewebu.ow.server.ecmimpl.cmis.object;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.xml.ws.Holder;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlEntryType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.EnumACLPropagation;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisACLType;
import org.oasis_open.docs.ns.cmis.ws._200908.ACLServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISACLModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISContentCollection;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPermissionCollection;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISInternalPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISMappedInternalPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;

/**
 *<p>
 * Base object class for all CMIS objects.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public abstract class OwCMISObjectBase implements OwCMISObject
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISObjectBase.class);

    private OwCMISObjectClass m_objectclass;

    protected CmisObjectType m_cmisObjType;
    protected OwCMISNetwork m_network;

    private OwCMISObjectModel objectModel;
    private OwStandardPropertyCollection internalCache;

    private String m_id;
    private String m_decodedID;;

    public static final String CUSTOMIZE_CLASS_EP = "cmis.object.reset.customize.class";
    public static final String PROCESS_NATIVE_PROPERITIES_EP = "cmis.object.process.native.properties";
    public static final String REQUEST_CACHED_PROPERITIES_EP = "cmis.object.request.cached.properties";
    public static final String FILTER_PROPERTY_EXTENSIONS_EP = "cmis.object.filter.property.extensions";
    public static final String ADD_PROPERTY_EXTENSIONS_EP = "cmis.object.add.property.extensions";

    /** create a folder object wrapper
     * 
     * @param network_p OwCMISNetwork
     * @param objectModel_p OwCMISObjectModel 
     * @param object_p CmisObjectType the native object
     * @throws OwException
     */
    public OwCMISObjectBase(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p, CmisObjectType object_p) throws OwException
    {
        m_network = network_p;
        this.objectModel = objectModel_p;
        resetNativeObject(object_p);
    }

    protected void resetNativeObject(CmisObjectType object_p) throws OwException
    {
        m_cmisObjType = object_p;

        m_decodedID = OwCMISPropertyNames.OBJECT_ID.getIdValue(m_cmisObjType);
        m_id = encodeID(m_decodedID);

        if (m_id == null)
        {
            LOG.error("OwCMISObjectBase.reset(): Could not initialize CMIS object - the object ID property is missing!");
            throw new OwInvalidOperationException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.resetNativeObject.error", "Error while reseting the CMIS object state!"));
        }

        String objTypeId = OwCMISPropertyNames.OBJECT_TYPE_ID.getIdValue(m_cmisObjType);

        if (objTypeId == null)
        {
            LOG.error("OwCMISObjectBase.reset(): Could not initialize CMIS object - the object type ID property is missing!");
            throw new OwInvalidOperationException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.resetNativeObject.error", "Error while reseting the CMIS object state!"));
        }

        m_objectclass = this.objectModel.getObjectClass(objTypeId);

        OwCMISResource resource = getResource();
        OwCMISObjectExtension objectExtension = resource.getExtension(CUSTOMIZE_CLASS_EP, OwCMISObjectExtension.class, m_objectclass);
        m_objectclass = objectExtension.customizeClass(m_cmisObjType, m_objectclass, m_network);

        initCache();
        if (m_cmisObjType.getAllowableActions() == null)
        {
            LOG.error("OwCMISObjectBase.reset(): Could not initialize CMIS object - the allowableActions were not retrieved (getAllowableActions()==null)!");
            throw new OwInvalidOperationException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.resetNativeObject.error", "Error while reseting the CMIS object state!"));
        }
    }

    public OwCMISObjectClass getObjectClass()
    {
        return m_objectclass;
    }

    public String getMIMEType() throws OwException
    {
        return m_objectclass.getMimetype();
    }

    public String getDMSID() throws OwException
    {
        return OwCMISSimpleDMSID.createDMSID(getNetwork().getDMSPrefix(), getResourceID(), getID());
    }

    public int getType()
    {
        return m_objectclass.getType();
    }

    public void add(OwObject object_p) throws OwException
    {
        LOG.fatal("OwCMISObjectBase.add():CMIS child count is not supported for object java class " + getClass().getName());
        throw new OwNotSupportedException(getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean canAdd(OwObject object_p, int context_p) throws OwException
    {
        return false;
    }

    public boolean canChangeClass() throws OwException
    {
        //by default false
        return false;
    }

    public boolean canDelete(int context_p) throws OwException
    {
        return m_cmisObjType.getAllowableActions().isCanDeleteObject().booleanValue();
    }

    public boolean canFilterChilds() throws OwException
    {
        //by default false
        return false;
    }

    public boolean canGetPermissions() throws OwException
    {
        try
        {
            this.objectModel.getACLModel();
            return true;
        }
        catch (OwNotSupportedException e)
        {
            LOG.warn("ACL not supported!");
            return false;
        }
    }

    public boolean canGetProperties(int context_p) throws OwException
    {
        return true;
    }

    public boolean canLock() throws OwException
    {
        return false;
    }

    public boolean canMove(OwObject object_p, OwObject oldParent_p, int context_p) throws OwException
    {
        return false;
    }

    public boolean canRemoveReference(OwObject object_p, int context_p) throws OwException
    {
        return false;
    }

    public boolean canSetPermissions() throws OwException
    {
        try
        {
            OwCMISACLModel aclModel = this.objectModel.getACLModel();
            return aclModel.canManageACL();
        }
        catch (OwNotSupportedException e)
        {
            LOG.warn("ACL not supported!");
            return false;
        }

    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws OwException
    {

    }

    public void delete() throws OwException
    {

    }

    public int getChildCount(int[] objectTypes_p, int context_p) throws OwException
    {
        LOG.fatal("OwCMISObjectBase.getChildCount():CMIS child count is not supported for object java class " + getClass().getName());
        throw new OwNotSupportedException(getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public OwCMISObject createCopy(OwCMISObject copyParent_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, int[] childTypes_p) throws OwException
    {

        try
        {
            OwCMISNetwork network = getNetwork();
            OwPropertyCollection properties = getProperties(null);
            OwPropertyCollection propertiesToSet = new OwStandardPropertyCollection();
            Set<?> propertiesEntries = properties.entrySet();
            for (Iterator<?> i = propertiesEntries.iterator(); i.hasNext();)
            {
                Map.Entry propertyEntry = (Entry) i.next();
                Object propertyKey = propertyEntry.getKey();
                OwProperty property = (OwProperty) propertyEntry.getValue();
                if (!property.isReadOnly(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS) && !property.getPropertyClass().isSystemProperty())
                {
                    if (property.getValue() != null)
                    {
                        propertiesToSet.put(propertyKey, property);
                    }

                    if (properties_p != null && properties_p.containsKey(propertyKey))
                    {
                        propertiesToSet.put(propertyKey, properties_p.get(propertyKey));
                    }
                }
            }

            OwContentCollection contentCollection = null;
            if (hasContent(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
            {
                contentCollection = getContentCollection();
            }

            OwCMISPermissionCollection permissions = null;
            if (canGetPermissions())
            {
                permissions = getPermissions();
            }
            String copyDMSID = network.createNewObject(copyParent_p.getResource(), getClassName(), propertiesToSet, permissions, contentCollection, copyParent_p, getMIMEType(), getMIMEParameter());
            return network.getObjectFromDMSID(copyDMSID, true);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISObjectBase.createCopy():Could not create basic object copy!", e);
            throw new OwServerException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.copy.error", "Copy error!"), e);
        }

    }

    public String getClassName()
    {
        return getObjectClass().getClassName();
    }

    public OwCMISPermissionCollection getClonedPermissions() throws OwException
    {
        throw new OwNotSupportedException("OwCMISObjectBase.getClonedPermissions: Not implemented.");
    }

    @SuppressWarnings("rawtypes")
    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws OwException
    {
        try
        {
            return OwStandardPropertyClass.getClonedProperties(this, propertyNames_p);
        }
        catch (OwException owException)
        {
            throw owException;
        }
        catch (Exception e)
        {
            LOG.fatal("OwCMISObjectBase.getClonedProperties():Properties handling error! Error cloning object properties!", e);
            throw new OwInvalidOperationException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.properties.handling.error", "Properties handling error!"), e);
        }
    }

    @SuppressWarnings("rawtypes")
    public Collection getColumnInfoList() throws OwException
    {
        return null;
    }

    public OwContentCollection getContentCollection() throws OwException
    {
        if (m_objectclass.getType() == OwObjectReference.OBJECT_TYPE_DOCUMENT)
        {
            return new OwCMISContentCollection(this, m_network);
        }
        else
        {
            return null;
        }
    }

    @SuppressWarnings("rawtypes")
    public Collection getFilterProperties(Collection propertyNames_p) throws OwException
    {
        Collection<?> col = null;
        try
        {
            col = propertyNames_p == null ? m_objectclass.getPropertyClassNames() : propertyNames_p;
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception ex)
        {
            LOG.error("OwCMISObject.getFilterProperties: An error occurred while retrieving the list of properties names!", ex);
            throw new OwServerException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.properties.handling.error", "Properties handling error!"), ex);
        }
        //iterate over collection and add filter able properties to the return list
        LinkedList<OwCMISPropertyClass> retLst = new LinkedList<OwCMISPropertyClass>();
        for (Object name : col)
        {
            try
            {
                OwCMISPropertyClass prop = m_objectclass.getPropertyClass(name.toString());
                if (prop.isQueryable(OwCMISQueryContext.GET_PROPERTY))
                {
                    retLst.add(prop);
                }
            }
            catch (OwObjectNotFoundException e)
            {
                if (LOG.isDebugEnabled())
                {
                    LOG.debug("Could not retrieve the property definition of \"" + name + "\" from class \"" + getClassName() + "\" (Exception: " + e.getMessage() + ")");
                }
            }
            catch (OwException e)
            {
                throw e;
            }
        }
        return retLst;
    }

    public boolean getLock(int context_p) throws OwException
    {
        return false;
    }

    public String getLockUserID(int context_p) throws OwException
    {
        return null;
    }

    public boolean getMyLock(int context_p) throws OwException
    {
        return false;
    }

    public CmisObjectType getNativeObject()
    {
        return m_cmisObjType;
    }

    public OwObjectCollection getParents() throws OwException
    {
        return null;
    }

    public String getPath() throws OwException
    {
        return null;
    }

    public OwCMISPermissionCollection getPermissions() throws OwException
    {
        CmisAccessControlListType acl = fetchACL();

        return new OwCMISPermissionCollection(acl, getResource());
    }

    private CmisAccessControlListType fetchACL() throws OwException
    {
        OwCMISNetwork network = getNetwork();
        ACLServicePort aclService = network.getACLServicePort();

        try
        {
            CmisACLType serviceAcl = aclService.getACL(getResourceID(), m_decodedID, Boolean.FALSE, null);
            CmisAccessControlListType acl = serviceAcl.getACL();

            return acl;
        }
        catch (CmisException e)
        {
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISObjectBase.getPermissions: could not retrieve permissions " + catcher.getLogMessage(), e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."), false);
        }

    }

    private boolean validACLOperation(CmisAccessControlListType acl_p)
    {
        return acl_p != null && acl_p.getPermission() != null && !acl_p.getPermission().isEmpty();
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws OwException
    {
        if (permissions_p instanceof OwCMISPermissionCollection)
        {
            OwCMISPermissionCollection cmisPermissions = (OwCMISPermissionCollection) permissions_p;

            CmisAccessControlListType currentACL = fetchACL();
            CmisAccessControlListType[] aclOperations = cmisPermissions.diff(currentACL);

            CmisAccessControlListType removedACL = aclOperations[0];
            CmisAccessControlListType addedACL = aclOperations[1];

            OwCMISNetwork network = getNetwork();
            ACLServicePort aclService = network.getACLServicePort();

            try
            {
                if (LOG.isDebugEnabled())
                {
                    StringBuilder removedPermissions = new StringBuilder();
                    StringBuilder addedPermissions = new StringBuilder();
                    if (removedACL != null)
                    {
                        List<CmisAccessControlEntryType> removedACEs = removedACL.getPermission();
                        for (CmisAccessControlEntryType ace : removedACEs)
                        {
                            removedPermissions.append(ace.getPermission());
                            removedPermissions.append("@");
                            removedPermissions.append(ace.getPrincipal().getPrincipalId());
                        }
                    }

                    if (addedACL != null)
                    {
                        List<CmisAccessControlEntryType> addedACEs = addedACL.getPermission();
                        for (CmisAccessControlEntryType ace : addedACEs)
                        {
                            addedPermissions.append(ace.getPermission());
                            addedPermissions.append("@");
                            addedPermissions.append(ace.getPrincipal().getPrincipalId());
                        }
                    }

                    LOG.debug("Removing ACEs for OID " + m_decodedID + " : " + removedPermissions.toString());
                    LOG.debug("Adding ACEs for OID " + m_decodedID + " : " + addedPermissions.toString());
                }
                if (validACLOperation(addedACL) || validACLOperation(removedACL))
                {
                    aclService.applyACL(getResourceID(), m_decodedID, addedACL, removedACL, EnumACLPropagation.REPOSITORYDETERMINED, null);
                }
                else
                {
                    LOG.debug("OwCMISObjectBase.setPermissions : No ACL to set. ACLService.applyACL call skipped!");
                }

            }
            catch (CmisException e)
            {
                OwNetworkContext context = network.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error("OwCMISObjectBase.setPermissions: could not set permissions " + catcher.getLogMessage(), e);
                throw catcher.toOwException(context.localize("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."), false);
            }
            //finally
            //{

            //PERMISSION RELOAD QUICK-FIX - to be removed when document-model reload is implemented in the generic permissions UI   

            //                CmisAccessControlListType refetchedACL = fetchACL();
            //                cmisPermissions.reset(refetchedACL);

            //}

        }
        else
        {
            LOG.error("OwCMISObjectBase.setPermissions: Invalid permissions class " + permissions_p.getClass());
            throw new OwServerException(m_network.getContext().localize("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."));
        }

    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public OwPropertyCollection getProperties(Collection propertyNames_p) throws OwException
    {
        OwCMISObjectClass objectClass = getObjectClass();
        List<String> nativePropertiesNames = new LinkedList<String>();
        OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
        if (propertyNames_p == null)
        {
            propertyNames_p = objectClass.getPropertyClassNames();
        }
        for (Iterator i = propertyNames_p.iterator(); i.hasNext();)
        {
            String propertyClassName = (String) i.next();
            OwCMISPropertyClass propertyClass = objectClass.getPropertyClass(propertyClassName);
            if (propertyClass instanceof OwCMISNativePropertyClass)
            {
                OwCMISProperty prop = requestInternalCacheEx((OwCMISNativePropertyClass) propertyClass);
                if (prop == null)
                {
                    nativePropertiesNames.add(propertyClassName);
                    /*even if we need to request it from back-end system
                     *keep the order of the requested properties*/
                    properties.put(propertyClassName, null);
                }
                else
                {
                    properties.put(propertyClassName, prop);
                }
            }
            else if (propertyClass instanceof OwCMISInternalPropertyClass)
            {
                OwCMISInternalPropertyClass internalClass = (OwCMISInternalPropertyClass) propertyClass;
                OwCMISInternalProperty internalProperty = internalClass.createProperty(this);
                properties.put(propertyClass.getClassName(), internalProperty);
            }
            else
            {
                LOG.error("OwCMISObjectBase.getProperties(): Properties handling error! Unknown property java-class " + propertyClass.getClass());
                throw new OwInvalidOperationException(getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.properties.handling.error", "Properties handling error!"));
            }
        }

        if (nativePropertiesNames.size() > 0)
        {
            OwPropertyCollection nativeProperties = retrieveCmisProperties(nativePropertiesNames, true);
            properties.putAll(nativeProperties);
        }

        return properties;
    }

    @SuppressWarnings("rawtypes")
    public OwCMISProperty getProperty(String propertyName_p) throws OwException
    {
        OwPropertyCollection properties = getProperties(Arrays.asList(new String[] { propertyName_p }));
        if (properties == null || properties.isEmpty())
        {
            LOG.error("OwCMISObjectBase.getProperty(): Could not retrieve property " + propertyName_p);
            throw new OwObjectNotFoundException(getNetwork().getContext().localize2("ecmimpl.cmis.OwCMISObjectBase.undefined.property.error", "Undefined property error!Property %1 is not defined for object class %2!", propertyName_p, " unknown "));
        }
        else
        {
            Set entries = properties.entrySet();
            Entry thePropertyEntry = (Entry) entries.iterator().next();
            return (OwCMISProperty) thePropertyEntry.getValue();
        }

    }

    public OwCMISResource getResource() throws OwException
    {
        return this.objectModel.getResource();
    }

    public OwCMISObjectModel getObjectModel()
    {
        return this.objectModel;
    }

    public OwSearchTemplate getSearchTemplate() throws OwException
    {
        return null;
    }

    public void move(OwObject object_p, OwObject oldParent_p) throws OwException
    {

    }

    public void refreshProperties() throws OwException
    {
        //void
    }

    @SuppressWarnings("rawtypes")
    public void refreshProperties(Collection propertyClassNames_p) throws OwException
    {
        //void

    }

    public void removeReference(OwObject object_p) throws OwException
    {

    }

    public boolean setLock(boolean lock_p) throws OwException
    {
        return false;
    }

    public boolean canSetProperties(int contextStatus_p) throws OwException
    {
        return m_cmisObjType.getAllowableActions().isCanUpdateProperties();
    }

    public void setProperties(OwPropertyCollection properties_p) throws OwException
    {
        setProperties(properties_p, null);
    }

    @SuppressWarnings("unchecked")
    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws OwException
    {
        OwCMISNetwork network = getNetwork();
        OwCMISResource resource = getResource();

        OwCMISObjectExtension objectExtension = resource.getExtension(FILTER_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, null);
        OwPropertyCollection propertyExtensions = objectExtension.filterPropertyExtensions(getResource(), this.getClassName(), properties_p);

        OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
        properties.putAll(properties_p);
        if (propertyExtensions != null)
        {
            Set<?> extensionKeys = propertyExtensions.keySet();
            for (Object object : extensionKeys)
            {
                properties.remove(object);
            }
        }

        OwCMISPropertyCollectionConverter converter = new OwCMISStandardPropertyCollectionConverter();
        CmisPropertiesType nativeProperties = converter.createCmisProperties(properties, this, getResourceID(), getNetwork());

        objectExtension = resource.getExtension(ADD_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, nativeProperties);
        nativeProperties = objectExtension.addPropertyExtensions(nativeProperties, propertyExtensions, this, resource.getID(), getNetwork());

        ObjectServicePort objectService = network.getObjectServicePort();
        Holder<String> idHodler = new Holder<String>(getDecodedID());
        Holder<String> changeToken = new Holder<String>(getChangeToken());
        try
        {
            objectService.updateProperties(getResourceID(), idHodler, changeToken, nativeProperties, null);

            OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
            filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
            filter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());

            CmisObjectType newObject = objectService.getObject(getResourceID(), idHodler.value, null, Boolean.TRUE, EnumIncludeRelationships.NONE, filter.getFilterString(), Boolean.FALSE, Boolean.FALSE, null);
            resetNativeObject(newObject);
        }
        catch (CmisException e)
        {
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISObjectBase.setProperties(): Error while updating properties! A CMIS error occurred : " + catcher.getLogMessage(), e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISObjectBase.setProperties.error", "Error while updating properties!"), true);
        }
    }

    public String getID()
    {
        return m_id;
    }

    /**
     * Helper method which can be used to without calling
     * {@link #decodeID(String)}.
     * @return String representing the decodeID
     * @since 3.1.0.0
     */
    public String getDecodedID()
    {
        return m_decodedID;
    }

    public OwObject getInstance() throws OwException
    {
        return this;
    }

    @SuppressWarnings("rawtypes")
    public OwObjectCollection getChilds(int[] objectTypes_p, Collection propertyNames_p, OwSort sort_p, int maxSize_p, int versionSelection_p, OwSearchNode filterCriteria_p) throws OwException
    {
        LOG.fatal("OwCMISDocumentObject.getChilds():Retrieval of CMIS childs is not supported for object java class " + getClass().getName());
        throw new OwNotSupportedException(getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public String getMIMEParameter() throws OwException
    {
        return null;
    }

    public String getName()
    {
        OwCMISProperty nameProperty;
        try
        {
            nameProperty = getProperty(OwCMISPropertyNames.NAME.getId());
            Object name = nameProperty.getValue();
            if (name != null)
            {
                return name.toString();
            }
        }
        catch (OwException e)
        {
            LOG.debug("Could not retrieve the name property!", e);
        }
        return "";
    }

    public int getPageCount() throws OwException
    {
        return 0;
    }

    public String getResourceID() throws OwException
    {
        return getResource().getID();
    }

    public boolean hasContent(int context_p) throws OwException
    {
        return false;
    }

    public OwField getField(String strFieldClassName_p) throws OwException
    {
        return getProperty(strFieldClassName_p);
    }

    public String getFieldProviderName()
    {
        return null;
    }

    public Object getFieldProviderSource()
    {
        return null;
    }

    public int getFieldProviderType()
    {
        return OwFieldProvider.TYPE_META_OBJECT;
    }

    @SuppressWarnings("rawtypes")
    public Collection getFields() throws OwException
    {
        return getProperties(null).values();
    }

    public Object getSafeFieldValue(String name_p, Object defaultValue_p)
    {
        try
        {
            return getProperty(name_p).getValue();
        }
        catch (Exception e)
        {//ignore exception, this is a safe method with defined return value
            LOG.debug("OwCMISObject.getSafeFieldValue: error retrieving native value", e);
            return defaultValue_p;
        }
    }

    public void setField(String name_p, Object value_p) throws OwException
    {
    }

    protected OwCMISNetwork getNetwork()
    {
        return this.m_network;
    }

    /**
     * Method which handles the fall back retrieving of property.
     * <p>Simply calling the {@link #retrieveCmisProperties(List,boolean)} and
     * packing the <b>cmisPropId</b> into a list.</p>
     * @param cmisPropertyClassName_p a qualified or non-qualified CMIS property name
     * @return OwCMISProperty specific to the data type
     * @throws OwException
     */
    protected OwCMISProperty retrieveCmisProperty(String cmisPropertyClassName_p) throws OwException
    {
        LinkedList<String> lst = new LinkedList<String>();
        lst.add(cmisPropertyClassName_p);
        OwPropertyCollection propCol = retrieveCmisProperties(lst, true);

        return (OwCMISProperty) propCol.get(cmisPropertyClassName_p);
    }

    /**
     * Method which handles the fall back to retrieve more then one property from
     * back end. And add it to the current property collection of this object.
     * @param lstCmisPropertyClassNames_p List of CMIS property class names (qualified or non qualified)
     * @param strict_p if <code>true</code> the returned property collection will contain properties
     *                 mapped for the exact requested names property names<br>
     *                 if <code>false</code> the returned property collection will contain properties
     *                 mapped to their concrete names (see {@link OwCMISMappedInternalPropertyClass})<br>
     * @return OwPropertyCollection with the defined properties
     * @throws OwException
     */
    @SuppressWarnings("unchecked")
    protected OwPropertyCollection retrieveCmisProperties(List<String> lstCmisPropertyClassNames_p, boolean strict_p) throws OwException
    {
        try
        {
            OwCMISPropertiesFilter propertiesFilter = new OwCMISPropertiesFilter();
            propertiesFilter.addAll(OwCMISQueryContext.GET_PROPERTY, lstCmisPropertyClassNames_p, getObjectClass(), getResource());
            String propertiesQueryString = propertiesFilter.getFilterString();

            CmisPropertiesType lst = getNetwork().getObjectServicePort().getProperties(getResourceID(), getDecodedID(), "".equals(propertiesQueryString) ? null : propertiesQueryString, null);
            List<CmisProperty> properties = lst.getProperty();

            OwPropertyCollection propertyCollection = new OwStandardPropertyCollection();
            for (CmisProperty prop : properties)
            {

                OwCMISPropertyClass propertyClass = getObjectClass().getPropertyClass(prop.getPropertyDefinitionId());
                if (propertyClass instanceof OwCMISNativePropertyClass)
                {
                    m_cmisObjType.getProperties().getProperty().add(prop);
                    OwCMISNativePropertyClass nativePropertyClass = (OwCMISNativePropertyClass) propertyClass;
                    OwCMISProperty property = nativePropertyClass.createProperty(prop, getNetwork());
                    String propertyCollectionName = propertyClass.getClassName();
                    if (strict_p)
                    {
                        Map<String, String> namesMap = propertiesFilter.getActualNamesMap();
                        propertyCollectionName = namesMap.get(propertyClass.getQueryName(OwCMISQueryContext.GET_PROPERTY));
                    }
                    propertyCollection.put(propertyCollectionName, property);
                    propertiesFilter.getActualNamesMap().remove(propertyClass.getQueryName(OwCMISQueryContext.GET_PROPERTY));
                }
                else
                {
                    LOG.error("OwCMISObjectBase.init() : native property class-miss-match  id=" + prop.getPropertyDefinitionId() + " java-property-class=" + propertyClass.getClass());
                }
            }

            if (propertiesFilter.getActualNamesMap().size() > 0)
            {
                Iterator<Entry<String, String>> itNullProp = propertiesFilter.getActualNamesMap().entrySet().iterator();
                while (itNullProp.hasNext())
                {
                    Entry<String, String> mis = itNullProp.next();
                    OwCMISPropertyClass propertyClass = getObjectClass().getPropertyClass(mis.getValue());
                    if (propertyClass instanceof OwCMISNativePropertyClass)
                    {
                        OwCMISProperty nullProp = ((OwCMISNativePropertyClass) propertyClass).createProperty(null, getNetwork());
                        if (strict_p)
                        {
                            propertyCollection.put(mis.getValue(), nullProp);
                        }
                        else
                        {
                            propertyCollection.put(propertyClass.getClassName(), nullProp);
                        }
                    }
                }
            }

            if (LOG.isDebugEnabled())
            {
                if (properties.size() != lstCmisPropertyClassNames_p.size())
                {
                    LOG.debug("OwCMISObjectBase.retrieveCmisProperties(): incomplete list retrieval with properties query String " + propertiesQueryString);
                    OwCMISObjectClass objectClass = getObjectClass();
                    Set<?> retrievedProperties = propertyCollection.keySet();
                    OwPropertyCollection nullProperties = new OwStandardPropertyCollection();
                    for (Iterator<?> i = lstCmisPropertyClassNames_p.iterator(); i.hasNext();)
                    {
                        String propertyName = (String) i.next();

                        if (!retrievedProperties.contains(propertyName))
                        {
                            OwCMISPropertyClass propertyClass = objectClass.getPropertyClass(propertyName);
                            OwCMISProperty nullProperty = propertyClass.newProperty(this, null, getNetwork());
                            String propertyCollectionName = propertyClass.getClassName();
                            if (strict_p)
                            {
                                Map<String, String> namesMap = propertiesFilter.getActualNamesMap();
                                propertyCollectionName = namesMap.get(propertyClass.getQueryName(OwCMISQueryContext.GET_PROPERTY));
                            }
                            nullProperties.put(propertyCollectionName, nullProperty);

                            LOG.debug("OwCMISObjectBase.retrieveCmisProperties():\t - " + propertyName);
                        }
                    }
                    propertyCollection.putAll(nullProperties);
                }
            }

            OwCMISResource resource = getResource();
            OwCMISObjectExtension objectExtension = resource.getExtension(PROCESS_NATIVE_PROPERITIES_EP, OwCMISObjectExtension.class, propertyCollection);
            OwPropertyCollection exProperties = objectExtension.processNativeProperties(this, propertyCollection, lst, getNetwork());

            return exProperties;
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (CmisException e)
        {
            OwNetworkContext context = getNetwork().getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISObjectBase.retrieveCmisProperties(): Error while retrieving properties! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISObjectBase.retrieveCmisProperties.cmis.error", "Error while retrieving properties!"), true);
        }
    }

    @Override
    public boolean equals(Object obj_p)
    {
        if (obj_p == null || !(obj_p instanceof OwCMISObjectBase))
        {
            return Boolean.FALSE.booleanValue();
        }
        else
        {
            try
            {
                return this.getDMSID().equals(((OwCMISObjectBase) obj_p).getDMSID());
            }
            catch (OwException ex)
            {
                LOG.warn("OwCMISObject.equals: Could not retrieve DMSID of object!", ex);
                return super.equals(obj_p);
            }
        }
    }

    @Override
    public int hashCode()
    {
        try
        {
            return getDMSID().hashCode();
        }
        catch (OwException e)
        {
            LOG.warn("OwCMISObject.hashCode: failed to retrieve DMSID", e);
            return super.hashCode();
        }
    }

    private OwCMISProperty requestInternalCacheEx(OwCMISNativePropertyClass propertyClass_p) throws OwException
    {

        OwCMISResource resource = getResource();
        OwCMISObjectExtension objectExtension = resource.getExtension(REQUEST_CACHED_PROPERITIES_EP, OwCMISObjectExtension.class, null);
        OwCMISNativeProperty property = objectExtension.requestCachedProperty(this, propertyClass_p, getNetwork());

        if (property != null)
        {
            return property;
        }
        else
        {
            return requestInternalCache(propertyClass_p);
        }
    }

    /**
     * Request the internal cached properties which are already retrieved.
     * If the requested property is not contained in the cache <code>null</code> will
     * be returned, else the OwCMISProperty is returned.
     * @param propertyClass_p OwCMISNativePropertyClass which represents the native property definition wrapper
     * @return OwCMISProperty or null
     * @throws OwInvalidOperationException if OwCMISProperty cannot be created from native value/type
     * @see OwCMISProperty
     * @see OwCMISNativePropertyClass
     */
    @SuppressWarnings("unchecked")
    private OwCMISProperty requestInternalCache(OwCMISNativePropertyClass propertyClass_p) throws OwException
    {
        OwCMISProperty retProp = (OwCMISProperty) this.internalCache.get(propertyClass_p.getNonQualifiedName());
        if (retProp == null)
        {
            retProp = null;
            for (CmisProperty cachedProp : m_cmisObjType.getProperties().getProperty())
            {
                if (cachedProp.getPropertyDefinitionId().equals(propertyClass_p.getNonQualifiedName()))
                {
                    retProp = (propertyClass_p).createProperty(cachedProp, getNetwork());
                    this.internalCache.put(propertyClass_p.getNonQualifiedName(), retProp);
                    break;
                }
            }
        }
        return retProp;
    }

    /**
     * Will clear the existing cache and initialize a fresh one.
     * <p>The cache will be initialized regarding the defined 
     * order in <code>getObjectClass().getPropertyClassNames()</code>.</p>
     * @throws OwException if unable to retrieve property class name collection
     */
    private void initCache() throws OwException
    {
        if (internalCache != null)
        {
            internalCache.clear();
            internalCache = null;
        }
        internalCache = new OwStandardPropertyCollection();
    }

    /**
     * Helper to encode the ID of an object.
     * @param id_p String
     * @return String which is encoded
     * @see #decodeID(String)
     * @since 3.1.0.0
     */
    protected String encodeID(String id_p)
    {
        return OwObjectIDCodeUtil.encode(id_p);
    }

    /**
     * Helper to decode the ID of an object. 
     * @param id_p String to decode
     * @return String
     * @see #encodeID(String)
     * @since 3.1.0.0
     */
    protected String decodeID(String id_p)
    {
        return OwObjectIDCodeUtil.decode(id_p);
    }

    /**
     * Get the value of change token.
     * @return String value or null
     * @throws OwException
     * @since 3.2.0.3
     */
    protected String getChangeToken() throws OwException
    {
        OwPropertyClass propClass = getObjectClass().getPropertyClass(OwCMISPropertyNames.CHANGE_TOKEN.getId());
        OwCMISProperty changeToken = getProperty(propClass.getClassName());
        return (String) changeToken.getValue();
    }
}