package com.wewebu.ow.server.ecmimpl.cmis.object;

import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;

import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISExtensionLibrary;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Object based extension interface.
 * <br/>
 * Extensions are aspect-oriented like , id based cross-cutting concerns.
 * Extensions are provided by extension libraries - {@link OwCMISExtensionLibrary} - and implemented as 
 * interface methods. Extensions are uniquely determined by implementing interface type and extension id.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public interface OwCMISObjectExtension
{
    /**
     * Extends the object's properties retrieval functionality.
     *    
     * @param object_p object whose properties were retrieved
     * @param processedProperties_p already processed properties (see {@link OwCMISObjectBase#retrieveCmisProperties(java.util.List, boolean)})
     * @param nativeProperties_p the natively CMIS retrieved properties  (see {@link OwCMISObjectBase#retrieveCmisProperties(java.util.List, boolean)})
     * @param network_p
     * @return a collection of properties based on given native properties CMIS collection and the already processed properties 
     * @throws OwException
     */
    OwPropertyCollection processNativeProperties(OwCMISObject object_p, OwPropertyCollection processedProperties_p, CmisPropertiesType nativeProperties_p, OwCMISNetwork network_p) throws OwException;

    /**
     * Customizes an object class upon object creation.
     * @param object_p
     * @param defaultObjectClass_p object class as provided by the adapter 
     * @param network_p
     * @return the customized class of the given object
     * @throws OwException
     */
    OwCMISObjectClass customizeClass(CmisObjectType object_p, OwCMISObjectClass defaultObjectClass_p, OwCMISNetwork network_p) throws OwException;

    /**
     * Extends the cache retrieval of properties for CMIS objects.  
     * @param object_p
     * @param propertyClass_p
     * @param network_p
     * @return  the cached property or null if not found
     * @throws OwException
     */
    OwCMISNativeProperty requestCachedProperty(OwCMISObjectBase object_p, OwCMISNativePropertyClass propertyClass_p, OwCMISNetwork network_p) throws OwException;

    /**
     * Filters out properties that should be handled by object extensions (for example {@link #addPropertyExtensions(CmisPropertiesType, OwPropertyCollection, OwCMISObject, String, OwCMISNetwork)}. 
     * @param objectClass_p  class of the owner object of the given property collection 
     * @param properties_p  
     * @return properties contained by properties_p that should be handled by the object extension (for example {@link #addPropertyExtensions(CmisPropertiesType, OwPropertyCollection, OwCMISObject, String, OwCMISNetwork)}.
     * @throws OwException
     */
    OwPropertyCollection filterPropertyExtensions(OwCMISResource resource_p, String objectClass_p, OwPropertyCollection properties_p) throws OwException;

    /**
     * Add Workdesk properties to the given native CMIS properties collection type.  
     * @param nativeProperties_p can be used as in/out parameter for performance purposes
     * @param propertyExtensions_p
     * @param object_p
     * @param network_p
     * @return {@link CmisPropertiesType} with all extension properties added to it  
     * @throws OwException
     */
    CmisPropertiesType addPropertyExtensions(CmisPropertiesType nativeProperties_p, OwPropertyCollection propertyExtensions_p, OwCMISObject object_p, String resourceID_p, OwCMISNetwork network_p) throws OwException;
}
