package com.wewebu.ow.server.ecmimpl.cmis.object;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPermissionCollection;
import com.wewebu.ow.server.util.OwXMLUtil;

/**
 *<p>
 * Simple skeleton implementation for creation of new objects.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISObjectSkeleton extends OwObjectSkeleton
{
    private OwCMISPermissionCollection permissions;

    public OwCMISObjectSkeleton(OwNetwork network_p, OwCMISObjectClass objectClass_p) throws Exception
    {
        super(network_p, objectClass_p);
        CmisAccessControlListType acl = new CmisAccessControlListType();
        permissions = new OwCMISPermissionCollection(acl, getResource());
    }

    public OwCMISObjectSkeleton(OwNetwork network_p, OwCMISObjectClass objectClass_p, OwXMLUtil initialValues_p) throws Exception
    {
        super(network_p, objectClass_p, initialValues_p);
    }

    @SuppressWarnings("rawtypes")
    @Override
    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception
    {
        LinkedList<String> lstprop = null;
        if (propertyNames_p != null && !propertyNames_p.isEmpty())
        {
            lstprop = new LinkedList<String>();
            Iterator<?> it = propertyNames_p.iterator();
            while (it.hasNext())
            {
                String simpleName = (String) it.next();
                //work with full qualified names
                lstprop.add(getObjectClass().getPropertyClass(simpleName).getClassName());
            }
        }

        return super.getProperties(lstprop);
    }

    @Override
    public OwProperty getProperty(String strPropertyName_p) throws Exception
    {
        //work with full qualified names
        return super.getProperty(getObjectClass().getPropertyClass(strPropertyName_p).getClassName());
    }

    @Override
    public OwCMISObjectClass getObjectClass()
    {
        return (OwCMISObjectClass) super.getObjectClass();
    }

    @Override
    public OwCMISResource getResource()
    {
        OwCMISObjectClass clazz = getObjectClass();
        return clazz.getResource();
    }

    @Override
    public OwCMISPermissionCollection getPermissions()
    {
        return permissions;
    }

    @Override
    public boolean canGetPermissions()
    {
        return true;
    }

    @Override
    public boolean canSetPermissions()
    {
        return false;
    }

}