package com.wewebu.ow.server.ecmimpl.cmis.object;

/**
 *<p>
 * CMIS query ability handling.<br/>
 * Interface which define handle the query name and query ability of a CMIS property definition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISQuerySchema
{
    /**
     * Request if this property is query able for given context.
     * @param context_p OwCMISQueryContext how to query
     * @return boolean <code>true</code> if query able
     * @see OwCMISQueryContext
     */
    boolean isQueryable(OwCMISQueryContext context_p);

    /**
     * Return the query name to be used for given context.
     * @param context_p OwCMISQueryContext how to query
     * @return boolean <code>true</code> if query able
     * @see OwCMISQueryContext
     */
    String getQueryName(OwCMISQueryContext context_p);
}
