package com.wewebu.ow.server.ecmimpl.cmis.object;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISRepositoryFolder.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISRepositoryFolder extends OwCMISFolderObject
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISRepositoryFolder.class);

    private static CmisObjectType getNativeRepositoryObject(OwCMISNetwork network_p, OwCMISResource resource_p) throws OwException
    {
        try
        {
            String filter = OwCMISPropertyNames.NONE.getId();
            ObjectServicePort objectService = network_p.getObjectServicePort();
            return objectService.getObject(resource_p.getID(), resource_p.getRepsitoryRootFolderId(), "*", Boolean.TRUE, EnumIncludeRelationships.NONE, filter, Boolean.FALSE, Boolean.FALSE, null);
        }
        catch (CmisException e)
        {
            OwNetworkContext context = network_p.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISRepositoryFolder.getNativeRepositoryObject(): Error while retrieving the native repository folder! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISRepositoryFolder.getNativeRepositoryObject.error", "Error while retrieving the native repository folder!"), true);
        }

    }

    public OwCMISRepositoryFolder(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p) throws OwException
    {
        super(network_p, objectModel_p, getNativeRepositoryObject(network_p, objectModel_p.getResource()));

    }

    @Override
    public boolean canDelete(int context_p) throws OwException
    {
        return Boolean.FALSE.booleanValue();
    }

    @Override
    public int getType()
    {
        return OwObjectReference.OBJECT_TYPE_ECM_ROOT_FOLDER;
    }

    @Override
    public OwObjectCollection getParents() throws OwException
    {//root folder has no parents, and an invalidArgument will be thrown
        return null;
    }

}
